/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements WriteStream<io.vertx.reactivex.core.buffer.Buffer>,
ReadStream<HttpClientResponse> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private Observable<HttpClientResponse> observable;
    private Flowable<HttpClientResponse> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<HttpClientResponse> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.http.HttpClientResponse, HttpClientResponse> conv = HttpClientResponse::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<HttpClientResponse> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.core.http.HttpClientResponse, HttpClientResponse> conv = HttpClientResponse::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<HttpClientResponse> pipe() {
        Pipe<HttpClientResponse> ret = Pipe.newInstance(this.delegate.pipe(), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<HttpClientResponse> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<HttpClientResponse> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<HttpClientResponse> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public HttpClientRequest write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Deprecated
    public HttpClientRequest handler(final Handler<HttpClientResponse> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                handler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    @Deprecated
    public HttpClientRequest pause() {
        this.delegate.pause();
        return this;
    }

    @Deprecated
    public HttpClientRequest resume() {
        this.delegate.resume();
        return this;
    }

    @Deprecated
    public HttpClientRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Deprecated
    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String getRawMethod() {
        String ret = this.delegate.getRawMethod();
        return ret;
    }

    public HttpClientRequest setRawMethod(String method) {
        this.delegate.setRawMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest write(String chunk) {
        this.delegate.write(chunk);
        return this;
    }

    public HttpClientRequest write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
        return this;
    }

    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest write(String chunk, String enc) {
        this.delegate.write(chunk, enc);
        return this;
    }

    public HttpClientRequest write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
        return this;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead() {
        this.delegate.sendHead();
        return this;
    }

    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    @Override
    public void end(String chunk) {
        this.delegate.end(chunk);
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    public void end(String chunk, String enc) {
        this.delegate.end(chunk, enc);
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer chunk) {
        this.delegate.end(chunk.getDelegate());
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.reactivex.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

