/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Promise;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.Future.class)
public class Future<T> {
    public static final TypeArg<Future> __TYPE_ARG = new TypeArg(obj -> new Future((io.vertx.core.Future)obj), Future::getDelegate);
    private final io.vertx.core.Future<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private Handler<AsyncResult<T>> cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Future that = (Future)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Future(io.vertx.core.Future delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public Future(io.vertx.core.Future delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.core.Future getDelegate() {
        return this.delegate;
    }

    public static <T> Future<T> future(final Handler<Promise<T>> handler) {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.future((Handler)new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                handler.handle(Promise.newInstance(event, TypeArg.unknown()));
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Deprecated
    public static <T> Future<T> future() {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.future(), TypeArg.unknown());
        return ret;
    }

    public static <T> Future<T> succeededFuture() {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.succeededFuture(), TypeArg.unknown());
        return ret;
    }

    public static <T> Future<T> succeededFuture(T result) {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.succeededFuture(result), TypeArg.unknown());
        return ret;
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.failedFuture((Throwable)t), TypeArg.unknown());
        return ret;
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        Future<T> ret = Future.newInstance(io.vertx.core.Future.failedFuture((String)failureMessage), TypeArg.unknown());
        return ret;
    }

    public boolean isComplete() {
        boolean ret = this.delegate.isComplete();
        return ret;
    }

    public Future<T> setHandler(final Handler<AsyncResult<T>> handler) {
        this.delegate.setHandler(new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)Future.this.__typeArg_0.wrap(ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<T> rxSetHandler() {
        return AsyncResultSingle.toSingle(handler -> this.setHandler((Handler<AsyncResult<T>>)handler));
    }

    @Deprecated
    public void complete(T result) {
        this.delegate.complete(this.__typeArg_0.unwrap(result));
    }

    @Deprecated
    public void complete() {
        this.delegate.complete();
    }

    @Deprecated
    public void fail(Throwable cause) {
        this.delegate.fail(cause);
    }

    @Deprecated
    public void fail(String failureMessage) {
        this.delegate.fail(failureMessage);
    }

    @Deprecated
    public boolean tryComplete(T result) {
        boolean ret = this.delegate.tryComplete(this.__typeArg_0.unwrap(result));
        return ret;
    }

    @Deprecated
    public boolean tryComplete() {
        boolean ret = this.delegate.tryComplete();
        return ret;
    }

    @Deprecated
    public boolean tryFail(Throwable cause) {
        boolean ret = this.delegate.tryFail(cause);
        return ret;
    }

    @Deprecated
    public boolean tryFail(String failureMessage) {
        boolean ret = this.delegate.tryFail(failureMessage);
        return ret;
    }

    public T result() {
        Object ret = this.__typeArg_0.wrap(this.delegate.result());
        return (T)ret;
    }

    public Throwable cause() {
        Throwable ret = this.delegate.cause();
        return ret;
    }

    public boolean succeeded() {
        boolean ret = this.delegate.succeeded();
        return ret;
    }

    public boolean failed() {
        boolean ret = this.delegate.failed();
        return ret;
    }

    public <U> Future<U> compose(final Function<T, Future<U>> mapper) {
        Future<T> ret = Future.newInstance(this.delegate.compose(new Function<T, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(T arg) {
                Future ret = (Future)mapper.apply(Future.this.__typeArg_0.wrap(arg));
                return ret.getDelegate();
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <U> Future<U> map(final Function<T, U> mapper) {
        Future<T> ret = Future.newInstance(this.delegate.map(new Function<T, U>(){

            @Override
            public U apply(T arg) {
                Object ret = mapper.apply(Future.this.__typeArg_0.wrap(arg));
                return ret;
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <V> Future<V> map(V value) {
        Future<T> ret = Future.newInstance(this.delegate.map(value), TypeArg.unknown());
        return ret;
    }

    public <V> Future<V> mapEmpty() {
        Future<T> ret = Future.newInstance(this.delegate.mapEmpty(), TypeArg.unknown());
        return ret;
    }

    @Deprecated
    public Handler<AsyncResult<T>> completer() {
        Handler ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    Future.this.delegate.completer().handle((Object)io.vertx.core.Future.succeededFuture((Object)Future.this.__typeArg_0.unwrap(ar.result())));
                } else {
                    Future.this.delegate.completer().handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        };
        return ret;
    }

    public Future<T> recover(final Function<Throwable, Future<T>> mapper) {
        Future<T> ret = Future.newInstance(this.delegate.recover(new Function<Throwable, io.vertx.core.Future<T>>(){

            @Override
            public io.vertx.core.Future<T> apply(Throwable arg) {
                Future ret = (Future)mapper.apply(arg);
                return ret.getDelegate();
            }
        }), this.__typeArg_0);
        return ret;
    }

    public Future<T> otherwise(final Function<Throwable, T> mapper) {
        Future<T> ret = Future.newInstance(this.delegate.otherwise(new Function<Throwable, T>(){

            @Override
            public T apply(Throwable arg) {
                Object ret = mapper.apply(arg);
                return Future.this.__typeArg_0.unwrap(ret);
            }
        }), this.__typeArg_0);
        return ret;
    }

    public Future<T> otherwise(T value) {
        Future<T> ret = Future.newInstance(this.delegate.otherwise(this.__typeArg_0.unwrap(value)), this.__typeArg_0);
        return ret;
    }

    public Future<T> otherwiseEmpty() {
        Future<T> ret = Future.newInstance(this.delegate.otherwiseEmpty(), this.__typeArg_0);
        return ret;
    }

    public static <T> Future<T> newInstance(io.vertx.core.Future arg) {
        return arg != null ? new Future<T>(arg) : null;
    }

    public static <T> Future<T> newInstance(io.vertx.core.Future arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new Future<T>(arg, __typeArg_T) : null;
    }
}

