/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class SingleUnmarshaller<T, B>
implements SingleTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;

    public SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = null;
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this.unwrap = unwrap;
        this.mappedType = null;
        this.mappedTypeRef = mappedTypeRef;
    }

    public SingleSource<T> apply(@NonNull Single<B> upstream) {
        Single unwrapped = upstream.map(this.unwrap::apply);
        Single unmarshalled = unwrapped.flatMap(buffer -> {
            try {
                Object obj = Objects.nonNull(this.mappedType) ? Json.mapper.readValue(buffer.getBytes(), this.mappedType) : Json.mapper.readValue(buffer.getBytes(), this.mappedTypeRef);
                return Single.just((Object)obj);
            }
            catch (IOException e) {
                return Single.error((Throwable)e);
            }
        });
        return unmarshalled;
    }
}

