/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.http.WebSocketBase;
import io.vertx.reactivex.core.http.WebSocketFrame;
import io.vertx.reactivex.core.net.SocketAddress;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.WebSocket.class)
public class WebSocket
implements WebSocketBase {
    public static final TypeArg<WebSocket> __TYPE_ARG = new TypeArg<WebSocket>(obj -> new WebSocket((io.vertx.core.http.WebSocket)obj), WebSocket::getDelegate);
    private final io.vertx.core.http.WebSocket delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocket that = (WebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocket(io.vertx.core.http.WebSocket delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.WebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer t) {
        this.delegate.end((Object)t.getDelegate());
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public WebSocketBase writePing(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePing(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase writePong(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writePong(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.pongHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public WebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocket handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocket write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public WebSocket writeFrame(WebSocketFrame frame) {
        this.delegate.writeFrame(frame.getDelegate());
        return this;
    }

    @Override
    public WebSocket writeFinalTextFrame(String text) {
        this.delegate.writeFinalTextFrame(text);
        return this;
    }

    @Override
    public WebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate());
        return this;
    }

    @Override
    public WebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.writeBinaryMessage(data.getDelegate());
        return this;
    }

    @Override
    public WebSocket writeTextMessage(String text) {
        this.delegate.writeTextMessage(text);
        return this;
    }

    @Override
    public WebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocket frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle((Object)WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    public static WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
        return arg != null ? new WebSocket(arg) : null;
    }
}

