/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.reactivex.core.ObservableHelper;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.WorkerExecutor;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.dns.DnsClient;
import io.vertx.reactivex.core.eventbus.EventBus;
import io.vertx.reactivex.core.eventbus.MessageConsumer;
import io.vertx.reactivex.core.file.AsyncFile;
import io.vertx.reactivex.core.file.FileSystem;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.http.WebSocket;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RxifiedExamples {
    public void toFlowable(Vertx vertx) {
        FileSystem fs = vertx.fileSystem();
        fs.open("/data.txt", new OpenOptions(), (Handler<AsyncResult<AsyncFile>>)((Handler)result -> {
            AsyncFile file = (AsyncFile)result.result();
            Flowable<Buffer> observable = file.toFlowable();
            observable.forEach(data -> System.out.println("Read data: " + data.toString("UTF-8")));
        }));
    }

    private static void checkAuth(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException();
    }

    public void delayFlowable(HttpServer server) {
        server.requestHandler((Handler<HttpServerRequest>)((Handler)request -> {
            if (request.method() == HttpMethod.POST) {
                request.pause();
                RxifiedExamples.checkAuth((Handler<AsyncResult<Void>>)((Handler)res -> {
                    request.resume();
                    if (res.succeeded()) {
                        Flowable<Buffer> flowable = request.toFlowable();
                        flowable.subscribe(buff -> {});
                    }
                }));
            }
        }));
    }

    public void single(Vertx vertx) {
        Single<HttpServer> single = vertx.createHttpServer().rxListen(1234, "localhost");
        single.subscribe(server -> {}, failure -> {});
    }

    public void maybe(Vertx vertx, int dnsPort, String dnsHost, String ipAddress) {
        DnsClient client = vertx.createDnsClient(dnsPort, dnsHost);
        Maybe<String> maybe = client.rxReverseLookup(ipAddress);
        maybe.subscribe(name -> {}, failure -> {}, () -> {});
    }

    public void completable(HttpServer server) {
        Completable single = server.rxClose();
        single.subscribe(() -> {}, failure -> {});
    }

    public void scheduler(Vertx vertx) {
        Scheduler scheduler = RxHelper.scheduler(vertx);
        Observable timer = Observable.interval((long)100L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler);
    }

    public void scheduler(WorkerExecutor workerExecutor) {
        Scheduler scheduler = RxHelper.blockingScheduler(workerExecutor);
        Observable timer = Observable.interval((long)100L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler);
    }

    public void schedulerHook(Vertx vertx) {
        RxJavaPlugins.setComputationSchedulerHandler(s -> RxHelper.scheduler(vertx));
        RxJavaPlugins.setIoSchedulerHandler(s -> RxHelper.blockingScheduler(vertx));
        RxJavaPlugins.setNewThreadSchedulerHandler(s -> RxHelper.scheduler(vertx));
    }

    public void unmarshaller(FileSystem fileSystem) {
        fileSystem.open("/data.txt", new OpenOptions(), (Handler<AsyncResult<AsyncFile>>)((Handler)result -> {
            AsyncFile file = (AsyncFile)result.result();
            Observable<Buffer> observable = file.toObservable();
            observable.compose(ObservableHelper.unmarshaller(MyPojo.class)).subscribe(mypojo -> {});
        }));
    }

    public void deployVerticle(Vertx vertx, Verticle verticle) {
        Single<String> deployment = RxHelper.deployVerticle(vertx, verticle);
        deployment.subscribe(id -> {}, err -> {});
    }

    public void embedded() {
        Vertx vertx = Vertx.vertx();
    }

    public void verticle() {
    }

    public void eventBusMessages(Vertx vertx) {
        EventBus eb = vertx.eventBus();
        MessageConsumer consumer = eb.consumer("the-address");
        Observable observable = consumer.toObservable();
        Disposable sub = observable.subscribe(msg -> {});
        vertx.setTimer(10000L, (Handler<Long>)((Handler)id -> sub.dispose()));
    }

    public void eventBusBodies(Vertx vertx) {
        EventBus eb = vertx.eventBus();
        MessageConsumer consumer = eb.consumer("the-address");
        Observable observable = consumer.bodyStream().toObservable();
    }

    public void eventBusMapReduce(Vertx vertx) {
        Observable observable = vertx.eventBus().consumer("heat-sensor").bodyStream().toObservable();
        observable.buffer(1L, TimeUnit.SECONDS).map(samples -> samples.stream().collect(Collectors.averagingDouble(d -> d))).subscribe(heat -> vertx.eventBus().send("news-feed", "Current heat is " + heat));
    }

    public void websocketServer(HttpServer server) {
        Observable<ServerWebSocket> socketObservable = server.websocketStream().toObservable();
        socketObservable.subscribe(socket -> System.out.println("Web socket connect"), failure -> System.out.println("Should never be called"), () -> System.out.println("Subscription ended or server closed"));
    }

    public void websocketServerBuffer(Flowable<ServerWebSocket> socketObservable) {
        socketObservable.subscribe(socket -> {
            Observable<Buffer> dataObs = socket.toObservable();
            dataObs.subscribe(buffer -> System.out.println("Got message " + buffer.toString("UTF-8")));
        });
    }

    public void websocketClient(Vertx vertx) {
        HttpClient client = vertx.createHttpClient(new HttpClientOptions());
        client.websocketStream(8080, "localhost", "/the_uri").toObservable().subscribe(ws -> {}, error -> {});
    }

    public void websocketClientBuffer(Flowable<WebSocket> socketObservable) {
        socketObservable.subscribe(socket -> {
            Flowable<Buffer> dataObs = socket.toFlowable();
            dataObs.subscribe(buffer -> System.out.println("Got message " + buffer.toString("UTF-8")));
        });
    }

    public void httpClientRequest(Vertx vertx) {
        HttpClient client = vertx.createHttpClient(new HttpClientOptions());
        HttpClientRequest request = client.request(HttpMethod.GET, 8080, "localhost", "/the_uri");
        request.toObservable().subscribe(response -> {}, error -> {});
        request.end();
    }

    public void httpClientResponse(HttpClientRequest request) {
        request.toObservable().subscribe(response -> {
            Observable<Buffer> observable = response.toObservable();
            observable.forEach(buffer -> {});
        });
    }

    public void httpClientResponseFlatMap(HttpClientRequest request) {
        request.toObservable().flatMap(HttpClientResponse::toObservable).forEach(buffer -> {});
    }

    public void httpServerRequest(HttpServer server) {
        Observable<HttpServerRequest> requestObservable = server.requestStream().toObservable();
        requestObservable.subscribe(request -> {});
    }

    public void httpServerRequestObservable(HttpServer server) {
        Observable<HttpServerRequest> requestObservable = server.requestStream().toObservable();
        requestObservable.subscribe(request -> {
            Observable<Buffer> observable = request.toObservable();
        });
    }

    public void httpServerRequestObservableUnmarshall(HttpServer server) {
        Observable<HttpServerRequest> requestObservable = server.requestStream().toObservable();
        requestObservable.subscribe(request -> {
            Observable observable = request.toObservable().compose(ObservableHelper.unmarshaller(MyPojo.class));
        });
    }

    public void timer(Vertx vertx) {
        vertx.timerStream(1000L).toObservable().subscribe(id -> System.out.println("Callback after 1 second"));
    }

    public void periodic(Vertx vertx) {
        vertx.periodicStream(1000L).toObservable().subscribe(id -> System.out.println("Callback every second"));
    }

    public void periodicUnsubscribe(Vertx vertx) {
        vertx.periodicStream(1000L).toObservable().subscribe((Observer)new Observer<Long>(){
            private Disposable sub;

            public void onSubscribe(@NonNull Disposable d) {
                this.sub = d;
            }

            public void onNext(Long aLong) {
                this.sub.dispose();
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    private class MyPojo {
        private MyPojo() {
        }
    }
}

