/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.rx.java.ContextScheduler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.UnmarshallerOperator;
import io.vertx.rxjava.core.Context;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.WorkerExecutor;
import io.vertx.rxjava.core.buffer.Buffer;
import rx.Observable;
import rx.Scheduler;
import rx.plugins.RxJavaSchedulersHook;

public class RxHelper {
    public static RxJavaSchedulersHook schedulerHook(Vertx vertx) {
        return io.vertx.rx.java.RxHelper.schedulerHook((io.vertx.core.Vertx)vertx.getDelegate());
    }

    public static RxJavaSchedulersHook schedulerHook(Context context) {
        return io.vertx.rx.java.RxHelper.schedulerHook((io.vertx.core.Context)context.getDelegate());
    }

    public static Scheduler scheduler(Vertx vertx) {
        return new ContextScheduler(vertx.getDelegate(), false);
    }

    public static Scheduler scheduler(WorkerExecutor executor) {
        return new ContextScheduler(executor.getDelegate(), false);
    }

    public static Scheduler scheduler(Context context) {
        return new ContextScheduler(context.getDelegate(), false);
    }

    public static Scheduler blockingScheduler(Vertx vertx) {
        return new ContextScheduler(vertx.getDelegate().getOrCreateContext(), true);
    }

    public static Scheduler blockingScheduler(Vertx vertx, boolean ordered) {
        return new ContextScheduler(vertx.getDelegate().getOrCreateContext(), true, ordered);
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(Class<T> mappedType) {
        return new UnmarshallerOperator<T, Buffer>(mappedType){

            public io.vertx.core.buffer.Buffer unwrap(Buffer buffer) {
                return buffer.getDelegate();
            }
        };
    }

    public static Observable<String> deployVerticle(Vertx vertx, Verticle verticle) {
        return RxHelper.deployVerticle(vertx, verticle, new DeploymentOptions());
    }

    public static Observable<String> deployVerticle(Vertx vertx, Verticle verticle, DeploymentOptions options) {
        ObservableFuture completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
        vertx.getDelegate().deployVerticle(verticle, options, completionHandler.toHandler());
        return completionHandler;
    }
}

