/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.JacksonFactory;
import java.util.Objects;
import rx.Observable;
import rx.Subscriber;

public abstract class UnmarshallerOperator<T, B>
implements Observable.Operator<T, B> {
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private ObjectCodec mapper;

    public UnmarshallerOperator(Class<T> mappedType) {
        this.mappedType = mappedType;
        this.mapper = null;
        this.mappedTypeRef = null;
    }

    public UnmarshallerOperator(Class<T> mappedType, ObjectCodec mapper) {
        this.mappedType = mappedType;
        this.mapper = mapper;
        this.mappedTypeRef = null;
    }

    public UnmarshallerOperator(TypeReference<T> mappedTypeRef) {
        this.mappedType = null;
        this.mapper = null;
        this.mappedTypeRef = mappedTypeRef;
    }

    public UnmarshallerOperator(TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this.mappedType = null;
        this.mapper = mapper;
        this.mappedTypeRef = mappedTypeRef;
    }

    public abstract Buffer unwrap(B var1);

    public Subscriber<? super B> call(final Subscriber<? super T> subscriber) {
        final Buffer buffer = Buffer.buffer();
        return new Subscriber<B>(subscriber){

            public void onCompleted() {
                try {
                    Object obj = null;
                    if (buffer.length() > 0) {
                        if (UnmarshallerOperator.this.mapper != null) {
                            JsonParser parser = UnmarshallerOperator.this.mapper.getFactory().createParser(buffer.getBytes());
                            obj = Objects.nonNull(UnmarshallerOperator.this.mappedType) ? UnmarshallerOperator.this.mapper.readValue(parser, UnmarshallerOperator.this.mappedType) : UnmarshallerOperator.this.mapper.readValue(parser, UnmarshallerOperator.this.mappedTypeRef);
                        } else {
                            obj = Objects.nonNull(UnmarshallerOperator.this.mappedType) ? Json.CODEC.fromBuffer(buffer, UnmarshallerOperator.this.mappedType) : JacksonFactory.CODEC.fromBuffer(buffer, UnmarshallerOperator.this.mappedTypeRef);
                        }
                    }
                    subscriber.onNext(obj);
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onNext(B item) {
                buffer.appendBuffer(UnmarshallerOperator.this.unwrap(item));
            }
        };
    }
}

