/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.util;

import com.ongres.scram.client.ScramClient;
import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.exception.ScramException;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.ongres.scram.common.stringprep.StringPreparation;
import com.ongres.scram.common.stringprep.StringPreparations;
import io.netty.buffer.ByteBuf;
import io.vertx.pgclient.impl.codec.ScramClientInitialMessage;
import io.vertx.pgclient.impl.util.Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class ScramAuthentication {
    private static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
    private final String username;
    private final String password;
    private ScramSession scramSession;
    private ScramSession.ClientFinalProcessor clientFinalProcessor;

    public ScramAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public ScramClientInitialMessage createInitialSaslMessage(ByteBuf in) {
        ArrayList<String> mechanisms = new ArrayList<String>();
        while (0 != in.getByte(in.readerIndex())) {
            String mechanism = Util.readCStringUTF8(in);
            mechanisms.add(mechanism);
        }
        if (mechanisms.isEmpty()) {
            throw new UnsupportedOperationException("SASL Authentication : the server returned no mechanism");
        }
        if (!mechanisms.contains(SCRAM_SHA_256)) {
            throw new UnsupportedOperationException("SASL Authentication : only SCRAM-SHA-256 is currently supported, server wants " + mechanisms);
        }
        ScramClient scramClient = ScramClient.channelBinding((ScramClient.ChannelBinding)ScramClient.ChannelBinding.NO).stringPreparation((StringPreparation)StringPreparations.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanisms.toArray(new String[0])).setup();
        this.scramSession = scramClient.scramSession(this.username);
        return new ScramClientInitialMessage(this.scramSession.clientFirstMessage(), scramClient.getScramMechanism().getName());
    }

    public String receiveServerFirstMessage(ByteBuf in) {
        String serverFirstMessage = in.readCharSequence(in.readableBytes(), StandardCharsets.UTF_8).toString();
        ScramSession.ServerFirstProcessor serverFirstProcessor = null;
        try {
            serverFirstProcessor = this.scramSession.receiveServerFirstMessage(serverFirstMessage);
        }
        catch (ScramException e) {
            throw new UnsupportedOperationException(e);
        }
        this.clientFinalProcessor = serverFirstProcessor.clientFinalProcessor(this.password);
        return this.clientFinalProcessor.clientFinalMessage();
    }

    public void checkServerFinalMessage(ByteBuf in) {
        String serverFinalMessage = in.readCharSequence(in.readableBytes(), StandardCharsets.UTF_8).toString();
        try {
            this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        }
        catch (ScramInvalidServerSignatureException | ScramParseException | ScramServerErrorException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

