/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.sqlclient.impl.SocketConnectionBase;

public class InitiateSslHandler
extends ChannelInboundHandlerAdapter {
    private static final int code = 80877103;
    private final SocketConnectionBase conn;
    private final Promise<Void> upgradePromise;

    public InitiateSslHandler(SocketConnectionBase conn, Promise<Void> upgradePromise) {
        this.conn = conn;
        this.upgradePromise = upgradePromise;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeInt(0);
        byteBuf.writeInt(80877103);
        byteBuf.setInt(0, byteBuf.writerIndex());
        ctx.writeAndFlush((Object)byteBuf, ctx.voidPromise());
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        byte b = byteBuf.getByte(0);
        byteBuf.release();
        switch (b) {
            case 83: {
                Handler handler = o -> {
                    AsyncResult res;
                    if (o instanceof AsyncResult && (res = (AsyncResult)o).failed()) {
                        return;
                    }
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.upgradePromise.complete();
                };
                this.conn.socket().upgradeToSsl(handler);
                break;
            }
            case 78: {
                this.upgradePromise.fail((Throwable)new Exception("Postgres Server does not handle SSL connection"));
                break;
            }
            default: {
                this.upgradePromise.fail((Throwable)new Exception("Invalid SSL connection message"));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof DecoderException) {
            DecoderException err = (DecoderException)cause;
            cause = err.getCause();
        }
        this.upgradePromise.tryFail(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.upgradePromise.tryFail((Throwable)new VertxException("SSL handshake failed", true));
    }
}

