/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgDecoder;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.sqlclient.ClosedConnectionException;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.ArrayDeque;
import java.util.Iterator;

public class PgCodec
extends CombinedChannelDuplexHandler<PgDecoder, PgEncoder> {
    private final ArrayDeque<PgCommandCodec<?, ?>> inflight = new ArrayDeque();

    public PgCodec(boolean useLayer7Proxy) {
        PgDecoder decoder = new PgDecoder(this.inflight);
        PgEncoder encoder = new PgEncoder(useLayer7Proxy, this.inflight);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.fail(ctx, cause);
        super.exceptionCaught(ctx, cause);
    }

    private void fail(ChannelHandlerContext ctx, Throwable cause) {
        Iterator<PgCommandCodec<?, ?>> it = this.inflight.iterator();
        while (it.hasNext()) {
            PgCommandCodec<?, ?> codec = it.next();
            it.remove();
            CommandResponse failure = CommandResponse.failure((Throwable)cause);
            failure.cmd = codec.cmd;
            ctx.fireChannelRead((Object)failure);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.fail(ctx, (Throwable)ClosedConnectionException.INSTANCE);
        super.channelInactive(ctx);
    }
}

