/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.impl.JsonRef;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class JsonObjectSchema
extends JsonObject
implements JsonSchema {
    private boolean annotated;

    public JsonObjectSchema(JsonObject json) {
        super(json.getMap());
        this.annotated = json.containsKey("__absolute_uri__") || json.containsKey("__absolute_ref__") || json.containsKey("__absolute_recursive_ref__");
    }

    @Override
    public JsonSchema annotate(String key, String value) {
        switch (key) {
            case "__absolute_uri__": {
                this.annotated = true;
                this.put("__absolute_uri__", value);
                break;
            }
            case "__absolute_ref__": {
                this.annotated = true;
                this.put("__absolute_ref__", value);
                break;
            }
            case "__absolute_recursive_ref__": {
                this.annotated = true;
                this.put("__absolute_recursive_ref__", value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported annotation: " + key);
            }
        }
        return this;
    }

    @Override
    public <R> R get(String key, R fallback) {
        return (R)this.getValue(key, fallback);
    }

    @Override
    public <R> R get(String key) {
        return (R)this.getValue(key);
    }

    @Override
    public Set<String> fieldNames() {
        if (this.annotated) {
            HashSet filteredFieldNames = new HashSet(super.fieldNames());
            filteredFieldNames.remove("__absolute_uri__");
            filteredFieldNames.remove("__absolute_ref__");
            filteredFieldNames.remove("__absolute_recursive_ref__");
            return Collections.unmodifiableSet(filteredFieldNames);
        }
        return super.fieldNames();
    }

    @Override
    public JsonObject resolve() {
        return JsonRef.resolve(this.copy());
    }
}

