/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSingleSchemaValidatorFactory;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.ValidatorContext;

public class NotValidatorFactory
extends BaseSingleSchemaValidatorFactory {
    @Override
    protected BaseSingleSchemaValidator instantiate(MutableStateValidator parent) {
        return new NotValidator(parent);
    }

    @Override
    protected String getKeyword() {
        return "not";
    }

    static class NotValidator
    extends BaseSingleSchemaValidator {
        public NotValidator(MutableStateValidator parent) {
            super(parent);
        }

        private boolean isValidSync(ValidatorContext context, Object in) {
            try {
                this.schema.validateSync(context, in);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            if (this.isValidSync(context, in)) {
                throw ValidationException.create("input should be invalid", "not", in);
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            return this.schema.validateAsync(context, in).compose(res -> Future.failedFuture((Throwable)((Object)ValidationException.create("input should be invalid", "not", in))), err -> Future.succeededFuture());
        }
    }
}

