/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSingleSchemaValidator;
import io.vertx.json.schema.common.BaseSingleSchemaValidatorFactory;
import io.vertx.json.schema.common.DefaultApplier;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.ValidatorContext;
import java.util.ArrayList;
import java.util.List;

public class ItemsValidatorFactory
extends BaseSingleSchemaValidatorFactory {
    @Override
    protected BaseSingleSchemaValidator instantiate(MutableStateValidator parent) {
        return new ItemsValidator(parent);
    }

    @Override
    protected String getKeyword() {
        return "items";
    }

    static class ItemsValidator
    extends BaseSingleSchemaValidator
    implements DefaultApplier {
        public ItemsValidator(MutableStateValidator parent) {
            super(parent);
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            in = JsonUtil.unwrap(in);
            if (in instanceof List) {
                List arr = (List)in;
                for (int i = 0; i < arr.size(); ++i) {
                    context.markEvaluatedItem(i);
                    this.schema.validateSync(context.lowerLevelContext(i), arr.get(i));
                }
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            if ((in = JsonUtil.unwrap(in)) instanceof List) {
                List arr = (List)in;
                ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
                for (int i = 0; i < arr.size(); ++i) {
                    context.markEvaluatedItem(i);
                    Future<Void> f = this.schema.validateAsync(context.lowerLevelContext(i), arr.get(i));
                    if (f.isComplete()) {
                        if (!f.failed()) continue;
                        return Future.failedFuture((Throwable)f.cause());
                    }
                    futs.add(f);
                }
                if (futs.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futs).compose(cf -> Future.succeededFuture());
            }
            return Future.succeededFuture();
        }

        @Override
        public Future<Void> applyDefaultValue(Object value) {
            if (!((value = JsonUtil.unwrap(value)) instanceof List)) {
                return Future.succeededFuture();
            }
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            List arr = (List)value;
            for (Object valToDefault : arr) {
                if (this.schema.isSync()) {
                    this.schema.getOrApplyDefaultSync(valToDefault);
                    continue;
                }
                futures.add(this.schema.getOrApplyDefaultAsync(valToDefault));
            }
            if (futures.isEmpty()) {
                return Future.succeededFuture();
            }
            return CompositeFuture.all(futures).mapEmpty();
        }
    }
}

