/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonFormatValidator;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.Validator;
import io.vertx.json.schema.impl.JsonObjectSchema;
import io.vertx.json.schema.impl.SchemaRepositoryImpl;

@VertxGen
public interface SchemaRepository {
    public static SchemaRepository create(JsonSchemaOptions options) {
        return new SchemaRepositoryImpl(options, JsonFormatValidator.DEFAULT_VALIDATOR);
    }

    public static SchemaRepository create(JsonSchemaOptions options, JsonFormatValidator jsonFormatValidator) {
        return new SchemaRepositoryImpl(options, jsonFormatValidator);
    }

    @Fluent
    public SchemaRepository dereference(JsonSchema var1) throws SchemaException;

    @Fluent
    public SchemaRepository dereference(String var1, JsonSchema var2) throws SchemaException;

    @Fluent
    public SchemaRepository preloadMetaSchema(FileSystem var1);

    @Fluent
    public SchemaRepository preloadMetaSchema(FileSystem var1, Draft var2);

    public Validator validator(JsonSchema var1);

    public Validator validator(String var1);

    public Validator validator(String var1, JsonSchemaOptions var2);

    default public Validator validator(JsonSchema schema, JsonSchemaOptions options) {
        return this.validator(schema, options, false);
    }

    public Validator validator(JsonSchema var1, JsonSchemaOptions var2, boolean var3);

    public JsonObject resolve(JsonObject var1);

    default public JsonObject resolve(String ref) {
        return this.resolve(this.find(ref));
    }

    default public JsonObject resolve(JsonSchema schema) {
        if (schema instanceof JsonObjectSchema) {
            return this.resolve(((JsonObjectSchema)schema).copy());
        }
        throw new UnsupportedOperationException("This schema doesn't support resolve()");
    }

    public JsonSchema find(String var1);
}

