/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.sqlclient.impl.command.TxCommand;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCTxOp<R>
extends AbstractJDBCAction<R> {
    private final TxCommand<R> op;

    public JDBCTxOp(JDBCStatementHelper helper, TxCommand<R> op, SQLOptions options) {
        super(helper, options);
        this.op = op;
    }

    @Override
    public R execute(Connection conn) throws SQLException {
        if (this.op.kind == TxCommand.Kind.BEGIN) {
            conn.setAutoCommit(false);
        } else {
            try {
                if (this.op.kind == TxCommand.Kind.COMMIT) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
            }
            finally {
                conn.setAutoCommit(false);
            }
        }
        return (R)this.op.result;
    }
}

