/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.jdbc.impl.actions.SQLValueProvider;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.jdbc.spi.JDBCDecoder;
import io.vertx.jdbcclient.impl.actions.JDBCColumnDescriptor;
import io.vertx.sqlclient.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class JDBCDecoderImpl
implements JDBCDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCDecoder.class);

    @Override
    public Object parse(ResultSet rs, int pos, JDBCColumnDescriptorProvider jdbcTypeLookup) throws SQLException {
        return this.decode(jdbcTypeLookup.apply(pos), cls -> cls == null ? rs.getObject(pos) : rs.getObject(pos, cls));
    }

    @Override
    public Object parse(CallableStatement cs, int pos, JDBCColumnDescriptorProvider jdbcTypeLookup) throws SQLException {
        return this.decode(jdbcTypeLookup.apply(pos), cls -> cls == null ? cs.getObject(pos) : cs.getObject(pos, cls));
    }

    @Override
    public Object decode(JDBCColumnDescriptor descriptor, SQLValueProvider valueProvider) throws SQLException {
        if (descriptor.isArray()) {
            return this.decodeArray(valueProvider, descriptor);
        }
        if (descriptor.jdbcType() == JDBCType.DATALINK) {
            return this.decodeLink(valueProvider, descriptor);
        }
        if (descriptor.jdbcType() == JDBCType.SQLXML) {
            return this.decodeXML(valueProvider, descriptor);
        }
        if (descriptor.jdbcType() == JDBCType.STRUCT) {
            return this.decodeStruct(valueProvider, descriptor);
        }
        if (descriptor.jdbcTypeWrapper().isBinaryType()) {
            return this.decodeBinary(valueProvider, descriptor);
        }
        if (descriptor.jdbcTypeWrapper().isNumberType()) {
            return this.decodeNumber(valueProvider, descriptor);
        }
        if (descriptor.jdbcTypeWrapper().isDateTimeType()) {
            return this.decodeDateTime(valueProvider, descriptor);
        }
        if (descriptor.jdbcTypeWrapper().isUnhandledType()) {
            return this.decodeUnhandledType(valueProvider, descriptor);
        }
        if (descriptor.jdbcTypeWrapper().isSpecificVendorType()) {
            return this.decodeSpecificVendorType(valueProvider, descriptor);
        }
        return this.cast(this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass()));
    }

    @Override
    public Object cast(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)value;
            return this.decodeArray(array, JDBCColumnDescriptor.create(() -> null, array::getBaseType, array::getBaseTypeName, () -> null));
        }
        if (value instanceof Blob) {
            Blob v = (Blob)value;
            return v.length() == 0L ? Buffer.buffer((int)0) : this.streamToBuffer(v.getBinaryStream(), Blob.class);
        }
        if (value instanceof Clob) {
            Clob v = (Clob)value;
            return v.length() == 0L ? "" : this.streamToBuffer(v.getAsciiStream(), Clob.class).toString();
        }
        if (value instanceof Ref) {
            return this.cast(((Ref)value).getObject());
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        return value;
    }

    protected Object decodeArray(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        Object value = this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass());
        if (value instanceof java.sql.Array) {
            return this.decodeArray((java.sql.Array)value, descriptor);
        }
        return this.cast(value);
    }

    protected Object decodeDateTime(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        try {
            return this.cast(valueProvider.apply(descriptor.jdbcTypeWrapper().vendorTypeClass()));
        }
        catch (SQLException e) {
            LOG.debug((Object)"Error when convert SQL date time. Try coerce value", (Throwable)e);
            Object value = valueProvider.apply(null);
            if (value == null) {
                return null;
            }
            try {
                if (value instanceof Time) {
                    return ((Time)value).toLocalTime().atOffset(ZoneOffset.UTC);
                }
                if (descriptor.jdbcType() == JDBCType.TIME || descriptor.jdbcType() == JDBCType.TIME_WITH_TIMEZONE) {
                    return LocalTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_TIME).atOffset(ZoneOffset.UTC);
                }
                if (value instanceof Timestamp) {
                    return ((Timestamp)value).toLocalDateTime().atOffset(ZoneOffset.UTC);
                }
                if (descriptor.jdbcType() == JDBCType.TIMESTAMP || descriptor.jdbcType() == JDBCType.TIMESTAMP_WITH_TIMEZONE) {
                    return LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME).atOffset(ZoneOffset.UTC);
                }
            }
            catch (DateTimeParseException ex) {
                LOG.debug((Object)"Error when coerce date time value", (Throwable)ex);
            }
            return this.cast(value);
        }
    }

    protected Object decodeNumber(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        try {
            return this.cast(valueProvider.apply(descriptor.jdbcTypeWrapper().vendorTypeClass()));
        }
        catch (SQLException e) {
            LOG.debug((Object)"Error when convert SQL number", (Throwable)e);
            return this.cast(valueProvider.apply(null));
        }
    }

    protected Object decodeBinary(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass());
        return v instanceof byte[] ? Buffer.buffer((byte[])((byte[])v)) : this.cast(v);
    }

    protected Object decodeStruct(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass());
        if (v instanceof Struct) {
            return this.cast(v);
        }
        return this.decodeUnhandledType(valueProvider, descriptor);
    }

    protected Object decodeLink(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass());
        if (v instanceof URL) {
            return v;
        }
        if (v instanceof String) {
            try {
                return new URL((String)v);
            }
            catch (MalformedURLException e) {
                throw new SQLException("Unable read data link", e);
            }
        }
        return this.cast(v);
    }

    protected Object decodeXML(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        Object v = this.getCoerceObject(valueProvider, descriptor.jdbcTypeWrapper().vendorTypeClass());
        if (v instanceof SQLXML) {
            return this.streamToBuffer(((SQLXML)v).getBinaryStream(), descriptor.jdbcTypeWrapper().vendorTypeClass());
        }
        return this.decodeUnhandledType(valueProvider, descriptor);
    }

    protected Object decodeUnhandledType(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        LOG.debug((Object)("Fallback to string when handling the unhandled JDBCType in Vertx " + descriptor));
        return Optional.ofNullable(this.cast(valueProvider.apply(null))).map(Object::toString).orElse(null);
    }

    protected Object decodeSpecificVendorType(SQLValueProvider valueProvider, JDBCColumnDescriptor descriptor) throws SQLException {
        LOG.debug((Object)("Fallback to string when handling the specific SQL vendor data type " + descriptor));
        return Optional.ofNullable(this.cast(valueProvider.apply(null))).map(Object::toString).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decodeArray(java.sql.Array value, JDBCColumnDescriptor baseType) throws SQLException {
        try {
            Object arr = value.getArray();
            if (arr != null) {
                int len = Array.getLength(arr);
                Object[] castedArray = new Object[len];
                for (int i = 0; i < len; ++i) {
                    int index = i;
                    castedArray[i] = this.decode(baseType, cls -> Array.get(arr, index));
                }
                Object[] objectArray = castedArray;
                return objectArray;
            }
            java.sql.Array array = value;
            return array;
        }
        finally {
            value.free();
        }
    }

    protected Object getCoerceObject(SQLValueProvider valueProvider, Class<?> cls) throws SQLException {
        try {
            return valueProvider.apply(null);
        }
        catch (SQLException e) {
            return valueProvider.apply(cls);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Buffer streamToBuffer(InputStream is, Class<?> dataTypeClass) throws SQLException {
        try (InputStream in = is;){
            int l;
            Buffer buffer = Buffer.buffer((int)1024);
            byte[] buf = new byte[1024];
            while ((l = in.read(buf)) > -1) {
                buffer.appendBytes(buf, 0, l);
            }
            Buffer buffer2 = buffer;
            return buffer2;
        }
        catch (IOException ioe) {
            throw new SQLException("Unable to read binary stream from " + dataTypeClass.getName(), ioe);
        }
    }
}

