/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi;

import io.vertx.jdbcclient.impl.actions.JDBCColumnDescriptor;
import io.vertx.jdbcclient.impl.actions.JDBCPropertyAccessor;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

@FunctionalInterface
public interface JDBCColumnDescriptorProvider {
    public static JDBCColumnDescriptorProvider fromParameter(PreparedStatement statement) {
        return col -> JDBCColumnDescriptor.create(() -> null, JDBCPropertyAccessor.jdbcType(() -> statement.getParameterMetaData().getParameterType(col)), JDBCPropertyAccessor.create(() -> statement.getParameterMetaData().getParameterTypeName(col)), JDBCPropertyAccessor.create(() -> statement.getParameterMetaData().getParameterClassName(col)));
    }

    public static JDBCColumnDescriptorProvider fromParameterMetaData(ParameterMetaData metaData) {
        return col -> JDBCColumnDescriptor.create(() -> null, JDBCPropertyAccessor.jdbcType(() -> metaData.getParameterType(col)), JDBCPropertyAccessor.create(() -> metaData.getParameterTypeName(col)), JDBCPropertyAccessor.create(() -> metaData.getParameterClassName(col)));
    }

    public static JDBCColumnDescriptorProvider fromResult(ResultSet rs) {
        return col -> JDBCColumnDescriptor.create(JDBCPropertyAccessor.create(() -> rs.getMetaData().getColumnLabel(col)), JDBCPropertyAccessor.jdbcType(() -> rs.getMetaData().getColumnType(col)), JDBCPropertyAccessor.create(() -> rs.getMetaData().getColumnTypeName(col)), JDBCPropertyAccessor.create(() -> rs.getMetaData().getColumnClassName(col)));
    }

    public static JDBCColumnDescriptorProvider fromResultMetaData(ResultSetMetaData metaData) {
        return col -> JDBCColumnDescriptor.create(JDBCPropertyAccessor.create(() -> metaData.getColumnLabel(col)), JDBCPropertyAccessor.jdbcType(() -> metaData.getColumnType(col)), JDBCPropertyAccessor.create(() -> metaData.getColumnTypeName(col)), JDBCPropertyAccessor.create(() -> metaData.getColumnClassName(col)));
    }

    public JDBCColumnDescriptor apply(int var1) throws SQLException;
}

