/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.ProxiedResponse;
import java.util.Map;
import java.util.Objects;

public class ProxiedRequest
implements ProxyRequest {
    private static final CharSequence X_FORWARDED_HOST = HttpHeaders.createOptimized((String)"x-forwarded-host");
    private static final MultiMap HOP_BY_HOP_HEADERS = MultiMap.caseInsensitiveMultiMap().add(HttpHeaders.CONNECTION, (CharSequence)"whatever").add(HttpHeaders.KEEP_ALIVE, (CharSequence)"whatever").add(HttpHeaders.PROXY_AUTHENTICATE, (CharSequence)"whatever").add(HttpHeaders.PROXY_AUTHORIZATION, (CharSequence)"whatever").add("te", "whatever").add("trailer", "whatever").add(HttpHeaders.TRANSFER_ENCODING, (CharSequence)"whatever").add(HttpHeaders.UPGRADE, (CharSequence)"whatever");
    final ContextInternal context;
    private HttpMethod method;
    private final HttpVersion version;
    private String uri;
    private final String absoluteURI;
    private Body body;
    private HostAndPort authority;
    private final MultiMap headers;
    HttpClientRequest request;
    private final HttpServerRequest proxiedRequest;

    public ProxiedRequest(HttpServerRequest proxiedRequest) {
        long contentLength = -1L;
        String contentLengthHeader = proxiedRequest.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLengthHeader != null) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.method = proxiedRequest.method();
        this.version = proxiedRequest.version();
        this.body = Body.body((ReadStream<Buffer>)proxiedRequest, contentLength);
        this.uri = proxiedRequest.uri();
        this.headers = MultiMap.caseInsensitiveMultiMap().addAll(proxiedRequest.headers());
        this.absoluteURI = proxiedRequest.absoluteURI();
        this.proxiedRequest = proxiedRequest;
        this.context = (ContextInternal)((HttpServerRequestInternal)proxiedRequest).context();
        this.authority = proxiedRequest.authority();
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public ProxyRequest setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public ProxyRequest setBody(Body body) {
        this.body = body;
        return this;
    }

    @Override
    public ProxyRequest setAuthority(HostAndPort authority) {
        Objects.requireNonNull(authority);
        this.authority = authority;
        return this;
    }

    @Override
    public HostAndPort getAuthority() {
        return this.authority;
    }

    @Override
    public String absoluteURI() {
        return this.absoluteURI;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public ProxyRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public HttpServerRequest proxiedRequest() {
        return this.proxiedRequest;
    }

    @Override
    public ProxyRequest release() {
        this.body.stream().resume();
        this.headers.clear();
        this.body = null;
        return this;
    }

    @Override
    public ProxyResponse response() {
        return new ProxiedResponse(this, this.proxiedRequest.response());
    }

    void sendRequest(Handler<AsyncResult<ProxyResponse>> responseHandler) {
        long len;
        this.request.response().map(r -> {
            r.pause();
            return new ProxiedResponse(this, this.proxiedRequest.response(), (HttpClientResponse)r);
        }).onComplete(responseHandler);
        this.request.setMethod(this.method);
        this.request.setURI(this.uri);
        for (Map.Entry header : this.headers) {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            if (HOP_BY_HOP_HEADERS.contains(name) || name.equalsIgnoreCase("host")) continue;
            this.request.headers().add(name, value);
        }
        if (this.authority != null) {
            this.request.authority(this.authority);
            HostAndPort proxiedAuthority = this.proxiedRequest.authority();
            if (!ProxiedRequest.equals(this.authority, proxiedAuthority)) {
                this.request.putHeader(X_FORWARDED_HOST, (CharSequence)proxiedAuthority.toString());
            }
        }
        if ((len = this.body.length()) >= 0L) {
            this.request.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(len));
        } else {
            Boolean isChunked = HttpUtils.isChunked(this.proxiedRequest.headers());
            this.request.setChunked(len == -1L && Boolean.TRUE == isChunked);
        }
        Pipe pipe = this.body.stream().pipe();
        pipe.endOnComplete(true);
        pipe.endOnFailure(false);
        pipe.to((WriteStream)this.request, ar -> {
            if (ar.failed()) {
                this.request.reset();
            }
        });
    }

    private static boolean equals(HostAndPort hp1, HostAndPort hp2) {
        if (hp1 == null || hp2 == null) {
            return false;
        }
        return hp1.host().equals(hp2.host()) && hp1.port() == hp2.port();
    }

    @Override
    public ProxyRequest putHeader(CharSequence name, CharSequence value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public Future<ProxyResponse> send(HttpClientRequest request) {
        PromiseInternal promise = this.context.promise();
        this.request = request;
        this.sendRequest((Handler<AsyncResult<ProxyResponse>>)promise);
        return promise.future();
    }
}

