/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Timer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcHeaderNames;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMessageDeframer;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;
import io.vertx.grpc.common.impl.GrpcWriteStreamBase;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GrpcServerRequestImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcServerRequestImpl<Req, Resp>, Req>
implements GrpcServerRequest<Req, Resp> {
    private static final Pattern TIMEOUT_PATTERN = Pattern.compile("([0-9]{1,8})([HMSmun])");
    private static final Map<String, TimeUnit> TIMEOUT_MAPPING;
    final HttpServerRequest httpRequest;
    final long timeout;
    final GrpcProtocol protocol;
    private GrpcServerResponseImpl<Req, Resp> response;
    private final GrpcMethodCall methodCall;
    private Timer deadline;

    private static long parseTimeout(String timeout) {
        Matcher matcher = TIMEOUT_PATTERN.matcher(timeout);
        if (matcher.matches()) {
            long value = Long.parseLong(matcher.group(1));
            TimeUnit unit = TIMEOUT_MAPPING.get(matcher.group(2));
            return unit.toMillis(value);
        }
        return 0L;
    }

    public GrpcServerRequestImpl(ContextInternal context, GrpcProtocol protocol, WireFormat format, HttpServerRequest httpRequest, GrpcMessageDeframer messageDeframer, GrpcMessageDecoder<Req> messageDecoder, GrpcMethodCall methodCall) {
        super((Context)context, (ReadStream)httpRequest, httpRequest.headers().get((CharSequence)GrpcHeaderNames.GRPC_ENCODING), format, messageDeframer, messageDecoder);
        String timeoutHeader = httpRequest.getHeader((CharSequence)GrpcHeaderNames.GRPC_TIMEOUT);
        long timeout = timeoutHeader != null ? GrpcServerRequestImpl.parseTimeout(timeoutHeader) : 0L;
        this.protocol = protocol;
        this.timeout = timeout;
        this.httpRequest = httpRequest;
        this.methodCall = methodCall;
    }

    ContextInternal context() {
        return this.context;
    }

    public void init(GrpcWriteStreamBase ws, boolean scheduleDeadline, long maxMessageSize) {
        this.response = (GrpcServerResponseImpl)ws;
        super.init(ws, maxMessageSize);
        if (this.timeout > 0L && scheduleDeadline) {
            Timer timer;
            this.deadline = timer = this.context.timer(this.timeout, TimeUnit.MILLISECONDS);
            timer.onSuccess(v -> this.response.handleTimeout());
        }
    }

    void cancelTimeout() {
        Timer timer = this.deadline;
        if (timer != null) {
            this.deadline = null;
            timer.cancel();
        }
    }

    @Override
    public String fullMethodName() {
        return this.methodCall.fullMethodName();
    }

    public MultiMap headers() {
        return this.httpRequest.headers();
    }

    @Override
    public ServiceName serviceName() {
        return this.methodCall.serviceName();
    }

    @Override
    public String methodName() {
        return this.methodCall.methodName();
    }

    @Override
    public GrpcServerRequestImpl<Req, Resp> handler(Handler<Req> handler) {
        if (handler != null) {
            return (GrpcServerRequestImpl)this.messageHandler(msg -> {
                Object decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    this.response.cancel();
                    return;
                }
                try {
                    handler.handle(decoded);
                }
                catch (Exception e) {
                    this.response.fail(e);
                }
            });
        }
        return (GrpcServerRequestImpl)this.messageHandler(null);
    }

    @Override
    public GrpcServerResponseImpl<Req, Resp> response() {
        return this.response;
    }

    @Override
    public HttpConnection connection() {
        return this.httpRequest.connection();
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public Timer deadline() {
        return this.deadline;
    }

    static {
        HashMap<String, TimeUnit> timeoutMapping = new HashMap<String, TimeUnit>();
        timeoutMapping.put("H", TimeUnit.HOURS);
        timeoutMapping.put("M", TimeUnit.MINUTES);
        timeoutMapping.put("S", TimeUnit.SECONDS);
        timeoutMapping.put("m", TimeUnit.MILLISECONDS);
        timeoutMapping.put("u", TimeUnit.MICROSECONDS);
        timeoutMapping.put("n", TimeUnit.NANOSECONDS);
        TIMEOUT_MAPPING = timeoutMapping;
    }
}

