/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.grpc.MethodDescriptor;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import java.util.HashMap;
import java.util.Map;

public class GrpcServerImpl
implements GrpcServer {
    private final Vertx vertx;
    private Handler<GrpcServerRequest<Buffer, Buffer>> requestHandler;
    private Map<String, MethodCallHandler<?, ?>> methodCallHandlers = new HashMap();

    public GrpcServerImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    public void handle(HttpServerRequest httpRequest) {
        GrpcMethodCall methodCall = new GrpcMethodCall(httpRequest.path());
        String fmn = methodCall.fullMethodName();
        MethodCallHandler<?, ?> method = this.methodCallHandlers.get(fmn);
        if (method != null) {
            this.handle(method, httpRequest, methodCall);
        } else {
            Handler<GrpcServerRequest<Buffer, Buffer>> handler = this.requestHandler;
            if (handler != null) {
                GrpcServerRequestImpl grpcRequest = new GrpcServerRequestImpl(httpRequest, GrpcMessageDecoder.IDENTITY, GrpcMessageEncoder.IDENTITY, methodCall);
                grpcRequest.init();
                handler.handle(grpcRequest);
            } else {
                httpRequest.response().setStatusCode(500).end();
            }
        }
    }

    private <Req, Resp> void handle(MethodCallHandler<Req, Resp> method, HttpServerRequest httpRequest, GrpcMethodCall methodCall) {
        GrpcServerRequestImpl grpcRequest = new GrpcServerRequestImpl(httpRequest, method.messageDecoder, method.messageEncoder, methodCall);
        grpcRequest.init();
        method.handle(grpcRequest);
    }

    @Override
    public GrpcServer callHandler(Handler<GrpcServerRequest<Buffer, Buffer>> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public <Req, Resp> GrpcServer callHandler(MethodDescriptor<Req, Resp> methodDesc, Handler<GrpcServerRequest<Req, Resp>> handler) {
        if (handler != null) {
            this.methodCallHandlers.put(methodDesc.getFullMethodName(), new MethodCallHandler<Req, Resp>(methodDesc, GrpcMessageDecoder.unmarshaller((MethodDescriptor.Marshaller)methodDesc.getRequestMarshaller()), GrpcMessageEncoder.marshaller((MethodDescriptor.Marshaller)methodDesc.getResponseMarshaller()), handler));
        } else {
            this.methodCallHandlers.remove(methodDesc.getFullMethodName());
        }
        return this;
    }

    private static class MethodCallHandler<Req, Resp>
    implements Handler<GrpcServerRequest<Req, Resp>> {
        final MethodDescriptor<Req, Resp> def;
        final GrpcMessageDecoder<Req> messageDecoder;
        final GrpcMessageEncoder<Resp> messageEncoder;
        final Handler<GrpcServerRequest<Req, Resp>> handler;

        MethodCallHandler(MethodDescriptor<Req, Resp> def, GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, Handler<GrpcServerRequest<Req, Resp>> handler) {
            this.def = def;
            this.messageDecoder = messageDecoder;
            this.messageEncoder = messageEncoder;
            this.handler = handler;
        }

        public void handle(GrpcServerRequest<Req, Resp> grpcRequest) {
            this.handler.handle(grpcRequest);
        }
    }
}

