/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor.type;

import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import java.util.HashMap;

public class PrimitiveTypeInfo
extends TypeInfo {
    public static final PrimitiveTypeInfo BOOLEAN;
    public static final PrimitiveTypeInfo BYTE;
    public static final PrimitiveTypeInfo SHORT;
    public static final PrimitiveTypeInfo INT;
    public static final PrimitiveTypeInfo LONG;
    public static final PrimitiveTypeInfo FLOAT;
    public static final PrimitiveTypeInfo DOUBLE;
    public static final PrimitiveTypeInfo CHAR;
    static final HashMap<String, PrimitiveTypeInfo> PRIMITIVES;
    final String name;
    final String boxedName;

    private PrimitiveTypeInfo(String name, String boxedName) {
        this.name = name;
        this.boxedName = boxedName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PrimitiveTypeInfo) {
            return this.name.equals(((PrimitiveTypeInfo)obj).name);
        }
        return false;
    }

    public ClassTypeInfo getBoxed() {
        return ClassTypeInfo.PRIMITIVES.get(this.boxedName);
    }

    @Override
    public ClassKind getKind() {
        return ClassKind.PRIMITIVE;
    }

    @Override
    public String format(boolean qualified) {
        return this.name;
    }

    static {
        PrimitiveTypeInfo[] primitives;
        BOOLEAN = new PrimitiveTypeInfo(Boolean.TYPE.getName(), Boolean.class.getName());
        BYTE = new PrimitiveTypeInfo(Byte.TYPE.getName(), Byte.class.getName());
        SHORT = new PrimitiveTypeInfo(Short.TYPE.getName(), Short.class.getName());
        INT = new PrimitiveTypeInfo(Integer.TYPE.getName(), Integer.class.getName());
        LONG = new PrimitiveTypeInfo(Long.TYPE.getName(), Long.class.getName());
        FLOAT = new PrimitiveTypeInfo(Float.TYPE.getName(), Float.class.getName());
        DOUBLE = new PrimitiveTypeInfo(Double.TYPE.getName(), Double.class.getName());
        CHAR = new PrimitiveTypeInfo(Character.TYPE.getName(), Character.class.getName());
        PRIMITIVES = new HashMap();
        for (PrimitiveTypeInfo primitive : primitives = new PrimitiveTypeInfo[]{BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, CHAR}) {
            PRIMITIVES.put(primitive.getName(), primitive);
        }
    }
}

