/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.plugin;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class VertxGrpcGeneratorImpl
extends Generator {
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;
    private static final String CLASS_PREFIX = "Vertx";
    private final boolean buildClient;
    private final boolean buildServer;
    private static final List<CharSequence> JAVA_KEYWORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false");

    VertxGrpcGeneratorImpl(boolean buildClient, boolean buildServer) {
        this.buildClient = buildClient;
        this.buildServer = buildServer;
    }

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    @Override
    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    @Override
    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of(request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains(protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        return this.generateFiles(services);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = fileProto.getPackage();
                serviceContext.vertxPackageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(serviceContext);
            }
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty(javaPackage = options.getJavaPackage())) {
            return javaPackage;
        }
        return Strings.nullToEmpty(proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        List allLocationsForService = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).collect(Collectors.toList());
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = allLocationsForService.stream().filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        serviceContext.javaDoc = this.getJavaDoc(this.getComments(serviceLocation), this.getServiceJavaDocPrefix());
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.methods.add(methodContext);
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = methodProto.getName();
        methodContext.vertxMethodName = VertxGrpcGeneratorImpl.mixedLower(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.javaDoc = this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix());
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.vertxCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private static String mixedLower(String word) {
        StringBuffer w = new StringBuffer();
        w.append(Character.toLowerCase(word.charAt(0)));
        boolean afterUnderscore = false;
        for (int i = 1; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c == '_') {
                afterUnderscore = true;
                continue;
            }
            if (afterUnderscore) {
                w.append(Character.toUpperCase(c));
            } else {
                w.append(c);
            }
            afterUnderscore = false;
        }
        if (JAVA_KEYWORDS.contains(w)) {
            w.append('_');
        }
        return w.toString();
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        return services.stream().map(this::buildFiles).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<PluginProtos.CodeGeneratorResponse.File> buildFiles(ServiceContext context) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        if (this.buildClient) {
            files.add(this.buildClientFile(context));
        }
        if (this.buildServer) {
            files.add(this.buildServerFile(context));
        }
        return files;
    }

    private PluginProtos.CodeGeneratorResponse.File buildClientFile(ServiceContext context) {
        context.fileName = CLASS_PREFIX + context.serviceName + "GrpcClient.java";
        context.className = CLASS_PREFIX + context.serviceName + "GrpcClient";
        return this.buildFile(context, this.applyTemplate("client.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildServerFile(ServiceContext context) {
        context.fileName = CLASS_PREFIX + context.serviceName + "GrpcServer.java";
        context.className = CLASS_PREFIX + context.serviceName + "GrpcServer";
        return this.buildFile(context, this.applyTemplate("server.mustache", context));
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context, String content) {
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private String absoluteFileName(ServiceContext ctx) {
        String dir = ctx.vertxPackageName.replace('.', '/');
        if (Strings.isNullOrEmpty(dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private static class MethodContext {
        public String methodName;
        public String vertxMethodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String vertxCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNameGetter() {
            return VertxGrpcGeneratorImpl.mixedLower("get_" + this.methodName + "_method");
        }

        public String methodHeader() {
            String mh = "";
            if (!Strings.isNullOrEmpty(this.javaDoc)) {
                mh = this.javaDoc;
            }
            if (this.deprecated) {
                mh = mh + "\n        @Deprecated";
            }
            return mh;
        }
    }

    private static class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String vertxPackageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public final List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }

        public List<MethodContext> allMethods() {
            return this.methods;
        }

        public List<MethodContext> streamMethods() {
            return this.methods.stream().filter(m -> m.isManyInput || m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryManyMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyUnaryMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyManyMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }
    }
}

