/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.grpc.MethodDescriptor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;

public class GrpcClientImpl
implements GrpcClient {
    private final Vertx vertx;
    private HttpClient client;

    public GrpcClientImpl(HttpClientOptions options, Vertx vertx) {
        this.vertx = vertx;
        this.client = vertx.createHttpClient(new HttpClientOptions(options).setProtocolVersion(HttpVersion.HTTP_2));
    }

    public GrpcClientImpl(Vertx vertx) {
        this(new HttpClientOptions().setHttp2ClearTextUpgrade(false), vertx);
    }

    @Override
    public Future<GrpcClientRequest<Buffer, Buffer>> request(SocketAddress server) {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.POST).setServer(server);
        return this.client.request(options).map(request -> new GrpcClientRequestImpl((HttpClientRequest)request, GrpcMessageEncoder.IDENTITY, GrpcMessageDecoder.IDENTITY));
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(SocketAddress server, MethodDescriptor<Req, Resp> method) {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.POST).setServer(server);
        GrpcMessageDecoder messageDecoder = GrpcMessageDecoder.unmarshaller((MethodDescriptor.Marshaller)method.getResponseMarshaller());
        GrpcMessageEncoder messageEncoder = GrpcMessageEncoder.marshaller((MethodDescriptor.Marshaller)method.getRequestMarshaller());
        return this.client.request(options).map(request -> {
            GrpcClientRequestImpl call = new GrpcClientRequestImpl((HttpClientRequest)request, messageEncoder, messageDecoder);
            call.fullMethodName(method.getFullMethodName());
            return call;
        });
    }

    @Override
    public Future<Void> close() {
        return this.client.close();
    }
}

