/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.DRDAConstants;
import io.vertx.db2client.impl.drda.Decimal;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Hashtable;

public abstract class DRDARequest {
    public static final String DB2_DRDA_SERVER_ID = "CSS";
    public static final String DB2_DRDA_CLIENT_ID = "DNC";
    final ByteBuf buffer;
    protected final ConnectionMetaData metadata;
    Deque<Integer> markStack = new ArrayDeque<Integer>(4);
    private int dssLengthLocation_ = 0;
    private int correlationID_ = 0;
    private boolean simpleDssFinalize = false;

    public DRDARequest(ByteBuf buffer, ConnectionMetaData metadata) {
        this.buffer = buffer;
        this.metadata = metadata;
    }

    String getHostname() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "localhost";
        }
    }

    protected final void createCommand() {
        this.buildDss(false, false, false, 1, ++this.correlationID_, false);
    }

    private final void buildDss(boolean dssHasSameCorrelator, boolean chainedToNextStructure, boolean nextHasSameCorrelator, int dssType, int corrId, boolean simpleFinalizeBuildingNextDss) {
        if (this.doesRequestContainData()) {
            if (this.simpleDssFinalize) {
                this.completeCommand();
            } else {
                this.finalizePreviousChainedDss(dssHasSameCorrelator);
            }
        }
        this.buffer.ensureWritable(6);
        this.dssLengthLocation_ = this.buffer.writerIndex();
        this.buffer.writeShort(-1);
        this.buffer.writeByte(-48);
        if (chainedToNextStructure) {
            dssType |= 0x40;
            if (nextHasSameCorrelator) {
                dssType |= 0x50;
            }
        }
        this.buffer.writeByte((int)((byte)dssType));
        this.buffer.writeShort((int)((short)corrId));
        this.simpleDssFinalize = simpleFinalizeBuildingNextDss;
    }

    final void createEncryptedCommandData() {
        this.buildDss(true, false, false, 3, this.correlationID_, false);
    }

    private final void finalizePreviousChainedDss(boolean dssHasSameCorrelator) {
        this.completeCommand();
        int pos = this.dssLengthLocation_ + 3;
        byte value = this.buffer.getByte(pos);
        value = (byte)(value | 0x40);
        if (dssHasSameCorrelator) {
            value = (byte)(value | 0x10);
        }
        this.buffer.setByte(pos, (int)value);
    }

    public final void completeCommand() {
        int totalSize = this.buffer.writerIndex() - this.dssLengthLocation_;
        int bytesRequiringContDssHeader = totalSize - Short.MAX_VALUE;
        if (bytesRequiringContDssHeader > 0) {
            int dataToShift;
            int contDssHeaderCount = bytesRequiringContDssHeader / 32765;
            if (bytesRequiringContDssHeader % 32765 != 0) {
                ++contDssHeaderCount;
            }
            int dataByte = this.buffer.writerIndex() - 1;
            int shiftOffset = contDssHeaderCount * 2;
            this.buffer.ensureWritable(shiftOffset);
            this.buffer.writerIndex(this.buffer.writerIndex() + shiftOffset);
            boolean passOne = true;
            do {
                if ((dataToShift = bytesRequiringContDssHeader % 32765) == 0) {
                    dataToShift = 32765;
                }
                byte[] array = this.buffer.array();
                System.arraycopy(array, (dataByte -= dataToShift) + 1, array, dataByte + shiftOffset + 1, dataToShift);
                int twoByteContDssHeader = dataToShift + 2;
                if (passOne) {
                    passOne = false;
                } else if (twoByteContDssHeader == Short.MAX_VALUE) {
                    twoByteContDssHeader = 65535;
                }
                this.buffer.setShort(dataByte + shiftOffset - 1, (int)((short)twoByteContDssHeader));
                shiftOffset -= 2;
            } while ((bytesRequiringContDssHeader -= dataToShift) > 0);
            totalSize = 65535;
        }
        this.buffer.setShort(this.dssLengthLocation_, (int)((short)totalSize));
    }

    protected final void updateLengthBytes() {
        int lengthLocation = this.markStack.pop();
        int length = this.buffer.writerIndex() - lengthLocation;
        int extendedLengthByteCount = this.calculateExtendedLengthByteCount(length);
        if (extendedLengthByteCount != 0) {
            this.ensureLength(extendedLengthByteCount);
            int extendedLength = length - 4;
            int extendedLengthLocation = lengthLocation + 4;
            byte[] array = this.buffer.array();
            System.arraycopy(array, extendedLengthLocation, array, extendedLengthLocation + extendedLengthByteCount, extendedLength);
            int shiftSize = (extendedLengthByteCount - 1) * 8;
            for (int i = 0; i < extendedLengthByteCount; ++i) {
                this.buffer.setByte(extendedLengthLocation++, (int)((byte)(extendedLength >>> shiftSize)));
                shiftSize -= 8;
            }
            this.buffer.writerIndex(this.buffer.writerIndex() + extendedLengthByteCount);
            length = extendedLengthByteCount + 4;
            length |= 0x8000;
        }
        this.buffer.setShort(lengthLocation, (int)((short)length));
    }

    final void writeScalarBytes(int codePoint, byte[] buff) {
        this.writeScalarBytes(codePoint, buff, 0, buff.length);
    }

    final void writeScalarBytes(int codePoint, byte[] buff, int start, int length) {
        this.writeLengthCodePoint(length + 4, codePoint);
        this.ensureLength(length);
        this.buffer.writeBytes(buff, start, length);
    }

    final void writeScalarPaddedBytes(byte[] buff, int paddedLength, byte padByte) {
        this.buffer.writeBytes(buff);
        this.padBytes(padByte, paddedLength - buff.length);
    }

    final void writeScalarString(int codePoint, String string) {
        this.writeScalarString(codePoint, string, 0, Integer.MAX_VALUE, null);
    }

    final void writeScalarString(int codePoint, String string, int byteMinLength, int byteLengthLimit, String sqlState) {
        int lengthPos = this.buffer.writerIndex();
        this.writeLengthCodePoint(0, codePoint);
        int stringByteLength = this.encodeString(string);
        if (stringByteLength > byteLengthLimit) {
            throw new IllegalArgumentException("SQLState=" + sqlState + " " + string);
        }
        if (stringByteLength < byteMinLength) {
            this.padBytes(this.metadata.getCCSID().encode(" ").get(), byteMinLength - stringByteLength);
            stringByteLength = byteMinLength;
        }
        this.buffer.setShort(lengthPos, (int)((short)(stringByteLength + 4)));
    }

    private void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset) {
        this.ensureLength(count * 3);
        int i = 0;
        while (i < count) {
            this.buffer.writeByte((int)((byte)lidAndLengthOverrides[offset][0]));
            this.buffer.writeShort((int)((short)lidAndLengthOverrides[offset][1]));
            ++i;
            ++offset;
        }
    }

    final void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset, boolean mddRequired, Hashtable map) {
        if (!mddRequired) {
            this.writeLidAndLengths(lidAndLengthOverrides, count, offset);
        } else {
            this.ensureLength(count * 3);
            int i = 0;
            while (i < count) {
                int protocolType = lidAndLengthOverrides[offset][0];
                Object entry = map.get(protocolType);
                int overrideLid = entry == null ? protocolType : (Integer)entry;
                this.buffer.writeByte((int)((byte)overrideLid));
                this.buffer.writeShort((int)((short)lidAndLengthOverrides[offset][1]));
                ++i;
                ++offset;
            }
        }
    }

    private final int calculateExtendedLengthByteCount(long ddmSize) {
        if (ddmSize <= 32767L) {
            return 0;
        }
        if (ddmSize <= Integer.MAX_VALUE) {
            return 4;
        }
        if (ddmSize <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    private int encodeString(String string) {
        int startPos = this.buffer.writerIndex();
        this.buffer.writeCharSequence((CharSequence)string, this.metadata.getCCSID());
        return this.buffer.writerIndex() - startPos;
    }

    final void writeLengthCodePoint(int length, int codePoint) {
        this.buffer.writeShort((int)((short)length));
        this.buffer.writeShort((int)((short)codePoint));
    }

    final void buildTripletHeader(int tripletLength, int tripletType, int tripletId) {
        this.ensureLength(3);
        this.buffer.writeByte((int)((byte)tripletLength));
        this.buffer.writeByte((int)((byte)tripletType));
        this.buffer.writeByte((int)((byte)tripletId));
    }

    final void writeLong6Bytes(long v) {
        this.ensureLength(6);
        this.buffer.writeShort((int)((short)(v >> 32)));
        this.buffer.writeInt((int)v);
    }

    final void writeDate(LocalDate date) {
        this.ensureLength(10);
        String d = date.format(DRDAConstants.DB2_DATE_FORMAT);
        this.buffer.writeCharSequence((CharSequence)d, StandardCharsets.UTF_8);
    }

    final void writeDate(Date date) {
        this.writeDate(date.toLocalDate());
    }

    final void writeTime(LocalTime time) {
        this.ensureLength(8);
        String t = time.format(DRDAConstants.DB2_TIME_FORMAT);
        this.buffer.writeCharSequence((CharSequence)t, StandardCharsets.UTF_8);
    }

    final void writeTime(Time time) {
        this.writeTime(time.toLocalTime());
    }

    final void writeTimestamp(LocalDateTime ts) {
        this.ensureLength(26);
        String t = ts.format(DRDAConstants.DB2_TIMESTAMP_FORMAT);
        this.buffer.writeCharSequence((CharSequence)t, StandardCharsets.UTF_8);
    }

    final void writeTimestamp(Timestamp timestamp) {
        this.writeTimestamp(timestamp.toLocalDateTime());
    }

    final void writeBigDecimal(BigDecimal v, int declaredPrecision, int declaredScale) {
        this.ensureLength(16);
        int length = Decimal.bigDecimalToPackedDecimalBytes(this.buffer, this.buffer.writerIndex(), v, declaredPrecision, declaredScale);
        this.buffer.writerIndex(this.buffer.writerIndex() + length);
    }

    final void writeSingleorMixedCcsidLDString(String s, Charset encoding) {
        byte[] b = s.getBytes(encoding);
        if (b.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("SQLState.LANG_STRING_TOO_LONG 32767");
        }
        this.writeLDBytes(b);
    }

    final void writeLDBytes(byte[] bytes) {
        this.buffer.writeShort(bytes.length);
        this.buffer.writeBytes(bytes);
    }

    final void writeLDBytes(ByteBuf bytes) {
        this.buffer.writeShort(bytes.readableBytes());
        this.buffer.writeBytes(bytes, bytes.readerIndex(), bytes.readableBytes());
    }

    final void writeScalar1Byte(int codePoint, int value) {
        this.ensureLength(5);
        this.buffer.writeByte(0);
        this.buffer.writeByte(5);
        this.buffer.writeShort((int)((short)codePoint));
        this.buffer.writeByte((int)((byte)value));
    }

    final void writeScalar2Bytes(int codePoint, int value) {
        this.ensureLength(6);
        this.buffer.writeByte(0);
        this.buffer.writeByte(6);
        this.buffer.writeShort((int)((short)codePoint));
        this.buffer.writeShort((int)((short)value));
    }

    final void writeScalar4Bytes(int codePoint, long value) {
        this.ensureLength(8);
        this.buffer.writeByte(0);
        this.buffer.writeByte(8);
        this.buffer.writeShort((int)((short)codePoint));
        this.buffer.writeInt((int)value);
    }

    final void writeScalar8Bytes(int codePoint, long value) {
        this.ensureLength(12);
        this.buffer.writeByte(0);
        this.buffer.writeByte(12);
        this.buffer.writeShort((int)((short)codePoint));
        this.buffer.writeLong(value);
    }

    protected final void markLengthBytes(int codePoint) {
        this.ensureLength(4);
        this.markStack.push(this.buffer.writerIndex());
        this.buffer.writerIndex(this.buffer.writerIndex() + 2);
        this.buffer.writeShort((int)((short)codePoint));
    }

    private final void padBytes(byte padByte, int length) {
        this.ensureLength(length);
        for (int i = 0; i < length; ++i) {
            this.buffer.writeByte((int)padByte);
        }
    }

    void ensureLength(int length) {
        this.buffer.ensureWritable(length);
    }

    private final boolean doesRequestContainData() {
        return this.buffer.writerIndex() != 0;
    }
}

