/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.ClientTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Locale;

final class CrossConverters {
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);

    private CrossConverters() {
    }

    static final Object setObject(int targetType, boolean source) {
        short numVal = source ? (short)1 : 0;
        switch (targetType) {
            case -7: 
            case 16: {
                return source;
            }
            case 5: {
                return numVal;
            }
            case 4: {
                return (int)numVal;
            }
            case -5: {
                return (long)numVal;
            }
            case 7: {
                return Float.valueOf(numVal);
            }
            case 8: {
                return (double)numVal;
            }
            case 3: {
                return BigDecimal.valueOf(numVal);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH boolean" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, byte source) {
        return CrossConverters.setObject(targetType, (short)source);
    }

    static final Object setObject(int targetType, short source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0;
            }
            case 5: {
                return source;
            }
            case 4: {
                return (int)source;
            }
            case -5: {
                return (long)source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH byte" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, int source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0;
            }
            case 5: {
                if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
                    throw new IllegalArgumentException("Outside range for SMALLINT (Short) " + source);
                }
                return (short)source;
            }
            case 4: {
                return source;
            }
            case -5: {
                return (long)source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH int " + ClientTypes.getTypeString(targetType));
    }

    static final boolean setBooleanFromObject(Object source, int sourceType) {
        switch (sourceType) {
            case 5: {
                return CrossConverters.getBooleanFromShort((Short)source);
            }
            case 4: {
                return CrossConverters.getBooleanFromInt((Integer)source);
            }
            case -5: {
                return CrossConverters.getBooleanFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return CrossConverters.getBooleanFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return CrossConverters.getBooleanFromDouble((Double)source);
            }
            case 3: {
                return CrossConverters.getBooleanFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return CrossConverters.getBooleanFromString((String)source);
            }
        }
        throw new IllegalArgumentException(ClientTypes.getTypeString(sourceType) + " boolean");
    }

    static final byte setByteFromObject(Object source, int sourceType) {
        switch (sourceType) {
            case 5: {
                return CrossConverters.getByteFromShort((Short)source);
            }
            case 4: {
                return CrossConverters.getByteFromInt((Integer)source);
            }
            case -5: {
                return CrossConverters.getByteFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return CrossConverters.getByteFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return CrossConverters.getByteFromDouble((Double)source);
            }
            case 3: {
                return CrossConverters.getByteFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return CrossConverters.getByteFromString((String)source);
            }
        }
        throw new IllegalArgumentException(ClientTypes.getTypeString(sourceType) + " byte");
    }

    static final Object setObject(int targetType, long source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0L;
            }
            case 5: {
                if (source > 32767L || source < -32768L) {
                    throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
                }
                return (short)source;
            }
            case 4: {
                if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
                }
                return (int)source;
            }
            case -5: {
                return source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH long" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, float source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0.0f;
            }
            case 5: {
                if (source > 32767.0f || source < -32768.0f) {
                    throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
                }
                return (short)source;
            }
            case 4: {
                if (source > 2.1474836E9f || source < -2.1474836E9f) {
                    throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
                }
                return (int)source;
            }
            case -5: {
                if (source > 9.223372E18f || source < -9.223372E18f) {
                    throw new IllegalArgumentException("Value outside range for BIGINT: " + source);
                }
                return (long)source;
            }
            case 7: {
                if (source == Float.POSITIVE_INFINITY || source == Float.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Value outside range for REAL: " + source);
                }
                return Float.valueOf(source);
            }
            case 8: {
                if ((double)source == Double.POSITIVE_INFINITY || (double)source == Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Value outside range for DOUBLE: " + source);
                }
                return Double.valueOf(String.valueOf(source));
            }
            case 3: {
                return new BigDecimal(String.valueOf(source));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH float" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, double source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0.0;
            }
            case 5: {
                if (source > 32767.0 || source < -32768.0) {
                    throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
                }
                return (short)source;
            }
            case 4: {
                if (source > 2.147483647E9 || source < -2.147483648E9) {
                    throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
                }
                return (int)source;
            }
            case -5: {
                if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
                    throw new IllegalArgumentException("Value outside range for BIGINT: " + source);
                }
                return (long)source;
            }
            case 7: {
                if (source > 3.4028234663852886E38 || source < -3.4028234663852886E38) {
                    throw new IllegalArgumentException("Value outside range for REAL: " + source);
                }
                return Float.valueOf((float)source);
            }
            case 8: {
                if (source == Double.POSITIVE_INFINITY || source == Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Value outside range for DOUBLE: " + source);
                }
                return source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH double" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, BigDecimal source) {
        switch (targetType) {
            case -7: 
            case 16: {
                return BigDecimal.valueOf(0L).compareTo(source) != 0;
            }
            case 5: {
                if (source.compareTo(bdMaxShortValue__) == 1 || source.compareTo(bdMinShortValue__) == -1) {
                    throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
                }
                return source.shortValue();
            }
            case 4: {
                if (source.compareTo(bdMaxIntValue__) == 1 || source.compareTo(bdMinIntValue__) == -1) {
                    throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
                }
                return source.intValue();
            }
            case -5: {
                if (source.compareTo(bdMaxLongValue__) == 1 || source.compareTo(bdMinLongValue__) == -1) {
                    throw new IllegalArgumentException("Value outside range for BIGINT: " + source);
                }
                return source.longValue();
            }
            case 7: {
                if (source.compareTo(bdMaxFloatValue__) == 1 || source.compareTo(bdMinFloatValue__) == -1) {
                    throw new IllegalArgumentException("Value outside range for REAL: " + source);
                }
                return Float.valueOf(source.floatValue());
            }
            case 8: {
                if (source.compareTo(bdMaxDoubleValue__) == 1 || source.compareTo(bdMinDoubleValue__) == -1) {
                    throw new IllegalArgumentException("Value outside range for DOUBLE: " + source);
                }
                return source.doubleValue();
            }
            case 3: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.Math.BigDecimal" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, Date source) {
        switch (targetType) {
            case 91: {
                return source;
            }
            case 93: {
                return new Timestamp(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.sql.Date" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, Time source) {
        switch (targetType) {
            case 92: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.sql.Time" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, Timestamp source) {
        switch (targetType) {
            case 93: {
                return source;
            }
            case 92: {
                return new Time(source.getTime());
            }
            case 91: {
                return new Date(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.sql.Timestamp" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetDriverType, String source) {
        switch (targetDriverType) {
            case -7: 
            case 16: {
                String cleanSource = source.trim().toUpperCase(Locale.ENGLISH);
                if (cleanSource.equals("UNKNOWN")) {
                    return null;
                }
                if (cleanSource.equals("TRUE")) {
                    return Boolean.TRUE;
                }
                if (cleanSource.equals("FALSE")) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException("SQLState.LANG_FORMAT_EXCEPTION " + ClientTypes.getTypeString(targetDriverType));
            }
            case 5: {
                return Short.valueOf(source);
            }
            case 4: {
                return Integer.valueOf(source);
            }
            case -5: {
                return Long.valueOf(source);
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return Double.valueOf(source);
            }
            case 3: {
                return new BigDecimal(source);
            }
            case 91: {
                return CrossConverters.getDateFromString(source);
            }
            case 92: {
                return CrossConverters.getTimeFromString(source);
            }
            case 93: {
                return CrossConverters.timestamp_valueOf(source, null);
            }
            case -1: 
            case 1: 
            case 12: {
                return source;
            }
            case 2005: {
                throw new UnsupportedOperationException("CLOB");
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH String " + ClientTypes.getTypeString(targetDriverType));
    }

    public static int getInputJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -6: 
            case 5: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return jdbcType;
    }

    static final Object setObject(int targetType, byte[] source) {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return source;
            }
            case 2004: {
                throw new UnsupportedOperationException("BLOB");
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH byte[]" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, Reader source, int length) {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return CrossConverters.setStringFromReader(source, length);
            }
            case 2005: {
                throw new UnsupportedOperationException("CLOB");
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.io.Reader" + ClientTypes.getTypeString(targetType));
    }

    private static String setStringFromReader(Reader r, int length) {
        StringWriter sw = new StringWriter();
        try {
            int read = r.read();
            int totalRead = 0;
            while (read != -1) {
                ++totalRead;
                sw.write(read);
                read = r.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new IllegalArgumentException("SQLState.READER_UNDER_RUN");
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static final Object setObjectFromCharacterStream(int targetType, InputStream source, Charset encoding, int length) {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return CrossConverters.setStringFromStream(source, encoding, length);
            }
            case 2005: {
                throw new UnsupportedOperationException("CLOB");
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.io.InputStream" + ClientTypes.getTypeString(targetType));
    }

    private static String setStringFromStream(InputStream is, Charset encoding, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read = is.read();
            while (read != -1) {
                ++totalRead;
                baos.write(read);
                read = is.read();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (length != Integer.MIN_VALUE && length != totalRead) {
            throw new IllegalStateException("SQLState.READER_UNDER_RUN");
        }
        return new String(baos.toByteArray(), encoding);
    }

    static final Object setObject(int targetType, Blob source) {
        switch (targetType) {
            case 2004: {
                return source;
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.sql.Blob" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObjectFromBinaryStream(int targetType, InputStream source, int length) {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return CrossConverters.setBytesFromStream(source, length);
            }
            case 2004: {
                throw new UnsupportedOperationException("BLOB");
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.io.InputStream" + ClientTypes.getTypeString(targetType));
    }

    private static byte[] setBytesFromStream(InputStream is, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read = is.read();
            while (read != -1) {
                ++totalRead;
                baos.write(read);
                read = is.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new IllegalStateException("SQLState.READER_UNDER_RUN");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    static final Object setObject(int targetType, Clob source) {
        switch (targetType) {
            case 2005: {
                return source;
            }
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH java.sql.Clob" + ClientTypes.getTypeString(targetType));
    }

    static final Object setObject(int targetType, Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return CrossConverters.setObject(targetType, (Boolean)source);
        }
        if (source instanceof Integer) {
            return CrossConverters.setObject(targetType, (Integer)source);
        }
        if (source instanceof Long) {
            return CrossConverters.setObject(targetType, (Long)source);
        }
        if (source instanceof Float) {
            return CrossConverters.setObject(targetType, ((Float)source).floatValue());
        }
        if (source instanceof Double) {
            return CrossConverters.setObject(targetType, (Double)source);
        }
        if (source instanceof BigDecimal) {
            return CrossConverters.setObject(targetType, (BigDecimal)source);
        }
        if (source instanceof Date) {
            return CrossConverters.setObject(targetType, (Date)source);
        }
        if (source instanceof Time) {
            return CrossConverters.setObject(targetType, (Time)source);
        }
        if (source instanceof Timestamp) {
            return CrossConverters.setObject(targetType, (Timestamp)source);
        }
        if (source instanceof String) {
            return CrossConverters.setObject(targetType, (String)source);
        }
        if (source instanceof byte[]) {
            return CrossConverters.setObject(targetType, (byte[])source);
        }
        if (source instanceof Blob) {
            return CrossConverters.setObject(targetType, (Blob)source);
        }
        if (source instanceof Clob) {
            return CrossConverters.setObject(targetType, (Clob)source);
        }
        if (source instanceof Array) {
            return CrossConverters.setObject(targetType, (Array)source);
        }
        if (source instanceof Ref) {
            return CrossConverters.setObject(targetType, (Ref)source);
        }
        if (source instanceof Short) {
            return CrossConverters.setObject(targetType, (Short)source);
        }
        if (source instanceof Byte) {
            return CrossConverters.setObject(targetType, (Byte)source);
        }
        if (source instanceof BigInteger) {
            return CrossConverters.setObject(targetType, new BigDecimal((BigInteger)source));
        }
        if (source instanceof java.util.Date) {
            return CrossConverters.setObject(targetType, new Timestamp(((java.util.Date)source).getTime()));
        }
        if (source instanceof Calendar) {
            return CrossConverters.setObject(targetType, new Timestamp(((Calendar)source).getTime().getTime()));
        }
        if (targetType == 2000) {
            return source;
        }
        throw new IllegalArgumentException("SQLState.LANG_DATA_TYPE_SET_MISMATCH " + source.getClass().getName() + " " + ClientTypes.getTypeString(targetType));
    }

    static final boolean getBooleanFromShort(short source) {
        return source != 0;
    }

    static final boolean getBooleanFromInt(int source) {
        return source != 0;
    }

    static final boolean getBooleanFromLong(long source) {
        return source != 0L;
    }

    static final boolean getBooleanFromFloat(float source) {
        return source != 0.0f;
    }

    static final boolean getBooleanFromDouble(double source) {
        return source != 0.0;
    }

    static final boolean getBooleanFromString(String source) {
        String trimmed = source.trim();
        return !trimmed.equals("0") && !trimmed.equals("false");
    }

    static final byte getByteFromShort(short source) {
        if (source > 127 || source < -128) {
            throw new IllegalArgumentException("Value outside range for TINYINT: " + source);
        }
        return (byte)source;
    }

    static final byte getByteFromInt(int source) {
        if (source > 127 || source < -128) {
            throw new IllegalArgumentException("Value outside range for TINYINT: " + source);
        }
        return (byte)source;
    }

    static final byte getByteFromLong(long source) {
        if (source > 127L || source < -128L) {
            throw new IllegalArgumentException("Value outside range for TINYINT: " + source);
        }
        return (byte)source;
    }

    static final byte getByteFromFloat(float source) {
        if (source > 127.0f || source < -128.0f) {
            throw new IllegalArgumentException("Value outside range for TINYINT: " + source);
        }
        return (byte)source;
    }

    static final byte getByteFromDouble(double source) {
        if (source > 127.0 || source < -128.0) {
            throw new IllegalArgumentException("Value outside range for TINYINT: " + source);
        }
        return (byte)source;
    }

    static final byte getByteFromBoolean(boolean source) {
        return source ? (byte)1 : 0;
    }

    static final byte getByteFromString(String source) {
        return CrossConverters.parseByte(source);
    }

    static final short getShortFromInt(int source) {
        if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
        }
        return (short)source;
    }

    static final short getShortFromLong(long source) {
        if (source > 32767L || source < -32768L) {
            throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
        }
        return (short)source;
    }

    static final short getShortFromFloat(float source) {
        if (source > 32767.0f || source < -32768.0f) {
            throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
        }
        return (short)source;
    }

    static final short getShortFromDouble(double source) {
        if (source > 32767.0 || source < -32768.0) {
            throw new IllegalArgumentException("Value outside range for SMALLINT: " + source);
        }
        return (short)source;
    }

    static final short getShortFromBoolean(boolean source) {
        return source ? (short)1 : 0;
    }

    static final short getShortFromString(String source) {
        try {
            return CrossConverters.parseShort(source);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("SQLState.LANG_FORMAT_EXCEPTION short", e);
        }
    }

    static final int getIntFromLong(long source) {
        if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
        }
        return (int)source;
    }

    static final int getIntFromFloat(float source) {
        if (source > 2.1474836E9f || source < -2.1474836E9f) {
            throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
        }
        return (int)source;
    }

    static final int getIntFromDouble(double source) {
        if (source > 2.147483647E9 || source < -2.147483648E9) {
            throw new IllegalArgumentException("Value outside range for INTEGER: " + source);
        }
        return (int)source;
    }

    static final int getIntFromBoolean(boolean source) {
        return source ? 1 : 0;
    }

    static final int getIntFromString(String source) {
        return CrossConverters.parseInt(source);
    }

    static final long getLongFromFloat(float source) {
        if (source > 9.223372E18f || source < -9.223372E18f) {
            throw new IllegalArgumentException("Value outside range for BIGINT: " + source);
        }
        return (long)source;
    }

    static final long getLongFromDouble(double source) {
        if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
            throw new IllegalArgumentException("Value outside range for BIGINT: " + source);
        }
        return (long)source;
    }

    static final long getLongFromBoolean(boolean source) {
        return source ? 1L : 0L;
    }

    static final long getLongFromString(String source) {
        return CrossConverters.parseLong(source);
    }

    static final float getFloatFromDouble(double source) {
        if (Float.isInfinite((float)source)) {
            throw new IllegalArgumentException("Value outside range for DOUBLE: " + source);
        }
        return (float)source;
    }

    static final float getFloatFromBoolean(boolean source) {
        return source ? 1.0f : 0.0f;
    }

    static final float getFloatFromString(String source) {
        return Float.parseFloat(source.trim());
    }

    static final double getDoubleFromBoolean(boolean source) {
        return source ? 1.0 : 0.0;
    }

    static final double getDoubleFromString(String source) {
        return Double.parseDouble(source.trim());
    }

    static final BigDecimal getBigDecimalFromString(String source) {
        return new BigDecimal(source.trim());
    }

    static final String getStringFromBytes(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            String hexForByte = Integer.toHexString(bytes[i] & 0xFF);
            if (hexForByte.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(hexForByte);
        }
        return stringBuffer.toString();
    }

    static final LocalDate getDateFromString(String source) {
        return LocalDate.parse(source);
    }

    static final LocalTime getTimeFromString(String source) {
        return LocalTime.parse(source);
    }

    static final Timestamp getTimestampFromString(String source, Calendar cal) {
        return CrossConverters.timestamp_valueOf(source, cal);
    }

    private static void initDatePortion(Calendar cal, String date) {
        if (date.length() != 10 || date.charAt(4) != '-' || date.charAt(7) != '-') {
            throw new IllegalArgumentException();
        }
        int year = CrossConverters.digit(date.charAt(0)) * 1000 + CrossConverters.digit(date.charAt(1)) * 100 + CrossConverters.digit(date.charAt(2)) * 10 + CrossConverters.digit(date.charAt(3));
        int month = CrossConverters.digit(date.charAt(5)) * 10 + CrossConverters.digit(date.charAt(6)) - 1;
        int day = CrossConverters.digit(date.charAt(8)) * 10 + CrossConverters.digit(date.charAt(9));
        cal.set(year, month, day);
    }

    private static int digit(char ch) {
        int result = Character.digit(ch, 10);
        if (result == -1) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static void initTimePortion(Calendar cal, String time) {
        if (time.length() != 8 || time.charAt(2) != ':' || time.charAt(5) != ':') {
            throw new IllegalArgumentException();
        }
        int hour = CrossConverters.digit(time.charAt(0)) * 10 + CrossConverters.digit(time.charAt(1));
        int minute = CrossConverters.digit(time.charAt(3)) * 10 + CrossConverters.digit(time.charAt(4));
        int second = CrossConverters.digit(time.charAt(6)) * 10 + CrossConverters.digit(time.charAt(7));
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
    }

    private static Timestamp timestamp_valueOf(String s, Calendar cal) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s = s.trim();
        if (cal == null) {
            return Timestamp.valueOf(s);
        }
        cal.clear();
        String[] dateAndTime = s.split(" ");
        if (dateAndTime.length != 2) {
            throw new IllegalArgumentException();
        }
        String dateString = dateAndTime[0];
        String timeAndNanoString = dateAndTime[1];
        CrossConverters.initDatePortion(cal, dateString);
        String[] timeAndNanos = timeAndNanoString.split("\\.");
        if (timeAndNanos.length < 1 || timeAndNanos.length > 2) {
            throw new IllegalArgumentException();
        }
        String timeString = timeAndNanos[0];
        CrossConverters.initTimePortion(cal, timeString);
        int nanos = 0;
        if (timeAndNanos.length > 1) {
            String nanoString = timeAndNanos[1];
            int extraZeros = 9 - nanoString.length();
            if (extraZeros < 0) {
                throw new IllegalArgumentException();
            }
            nanos = Integer.parseInt(nanoString);
            for (int i = 0; i < extraZeros; ++i) {
                nanos *= 10;
            }
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    private static byte parseByte(String s) throws NumberFormatException {
        int i = CrossConverters.parseInt(s);
        if (i < -128 || i > 127) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    private static short parseShort(String s) throws NumberFormatException {
        int i = CrossConverters.parseInt(s);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    private static int parseInt(String s) throws NumberFormatException {
        int digit;
        int limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / 10;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                CrossConverters.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(s);
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private static long parseLong(String s) throws NumberFormatException {
        int digit;
        long limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long multmin = limit / 10L;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                CrossConverters.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(s);
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private static void skipPadding(String s, int i, int length) throws NumberFormatException {
        while (i < length) {
            if (s.charAt(i++) == ' ') continue;
            throw new NumberFormatException(s);
        }
    }
}

