/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.codec.DB2PreparedStatement;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CommandResponse;

class CloseCursorCommandCodec
extends CommandCodec<Void, CloseCursorCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(CloseCursorCommandCodec.class);

    CloseCursorCommandCodec(CloseCursorCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        DB2PreparedStatement statement = (DB2PreparedStatement)((CloseCursorCommand)this.cmd).statement();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Close cursor with id=" + ((CloseCursorCommand)this.cmd).id()));
        }
        DB2PreparedStatement.QueryInstance query = statement.getQueryInstance(((CloseCursorCommand)this.cmd).id());
        statement.closeQuery(query);
        ByteBuf packet = this.allocateBuffer();
        DRDAQueryRequest closeCursor = new DRDAQueryRequest(packet, encoder.socketConnection.connMetadata);
        closeCursor.buildCLSQRY(statement.section, encoder.socketConnection.connMetadata.databaseName, query.queryInstanceId);
        closeCursor.completeCommand();
        this.sendNonSplitPacket(packet);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        DRDAQueryResponse closeCursor = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        closeCursor.readCursorClose();
        this.completionHandler.handle((Object)CommandResponse.success(null));
    }
}

