/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;

public class DB2ConnectionFactory
extends ConnectionFactoryBase {
    private int pipeliningLimit;

    public DB2ConnectionFactory(VertxInternal vertx, DB2ConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        DB2ConnectOptions options = (DB2ConnectOptions)connectOptions;
        this.pipeliningLimit = options.getPipeliningLimit();
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
    }

    protected Future<Connection> doConnectInternal(SocketAddress server, String username, String password, String database, EventLoopContext context) {
        return this.netClient.connect(server).flatMap(so -> {
            DB2SocketConnection conn = new DB2SocketConnection((NetSocketInternal)so, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, context);
            conn.init();
            return Future.future(p -> conn.sendStartupMessage(username, password, database, this.properties, (Promise<Connection>)p));
        });
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal contextInternal = (ContextInternal)context;
        QueryTracer tracer = contextInternal.tracer() == null ? null : new QueryTracer(contextInternal.tracer(), this.options);
        PromiseInternal promise = contextInternal.promise();
        this.connect(DB2ConnectionFactory.asEventLoopContext((ContextInternal)contextInternal)).map(conn -> {
            DB2ConnectionImpl db2Connection = new DB2ConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)db2Connection);
            return db2Connection;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

