/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.NestedCloseable;
import java.util.ArrayList;
import java.util.List;

public class CloseSequence
extends NestedCloseable
implements Closeable {
    private int current;
    private int idx;
    private final Closeable[] sequence;
    private final List<Promise<Void>> steps;

    public CloseSequence(Closeable ... sequence) {
        if (sequence.length == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Promise<Void>> steps = new ArrayList<Promise<Void>>(sequence.length);
        for (int i = 0; i < sequence.length; ++i) {
            steps.add(Promise.promise());
        }
        this.sequence = sequence;
        this.steps = steps;
        this.current = sequence.length;
        this.idx = sequence.length;
    }

    public synchronized boolean started() {
        return this.idx < this.sequence.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> progressTo(int step) {
        boolean checkProgress;
        if (step < 0 || step > this.steps.size() - 1) {
            throw new IllegalArgumentException("Invalid step");
        }
        CloseSequence closeSequence = this;
        synchronized (closeSequence) {
            if (step < this.idx) {
                checkProgress = this.idx == this.current;
                this.idx = step;
            } else {
                checkProgress = false;
            }
        }
        if (checkProgress) {
            this.tryProgress();
        }
        return this.steps.get(step).future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryProgress() {
        int curr;
        CloseSequence closeSequence = this;
        synchronized (closeSequence) {
            curr = this.current;
        }
        Promise<Void> promise = this.steps.get(curr - 1);
        this.sequence[curr - 1].close(promise);
        promise.future().onComplete(ar -> {
            boolean progress;
            CloseFuture owner;
            CloseSequence closeSequence = this;
            synchronized (closeSequence) {
                this.current = curr - 1;
                if (this.idx == this.current) {
                    owner = this.idx == 0 ? this.owner : null;
                    progress = false;
                } else {
                    progress = true;
                    owner = null;
                }
            }
            if (progress) {
                this.tryProgress();
            } else if (owner != null) {
                owner.remove(this);
            }
        });
    }

    public Future<Void> future() {
        return this.steps.get(0).future();
    }

    public Future<Void> close() {
        return this.progressTo(0);
    }

    @Override
    public void close(Completable<Void> completion) {
        this.progressTo(0).onComplete(completion);
    }
}

