/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class JsonUtil {
    public static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    public static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
    public static final Function<Object, ?> DEFAULT_CLONER = o -> {
        throw new IllegalStateException("Illegal type in Json: " + String.valueOf(o.getClass()));
    };

    public static Object wrapJsonValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        } else if (val instanceof List) {
            val = new JsonArray((List)val);
        } else if (val instanceof Instant) {
            val = DateTimeFormatter.ISO_INSTANT.format((Instant)val);
        } else if (val instanceof byte[]) {
            val = BASE64_ENCODER.encodeToString((byte[])val);
        } else if (val instanceof Buffer) {
            val = BASE64_ENCODER.encodeToString(((Buffer)val).getBytes());
        } else if (val instanceof Enum) {
            val = ((Enum)val).name();
        }
        return val;
    }

    public static Object deepCopy(Object val, Function<Object, ?> copier) {
        if (!(val == null || val instanceof Number || val instanceof Boolean || val instanceof String || val instanceof Character)) {
            if (val instanceof CharSequence) {
                val = val.toString();
            } else if (val instanceof Shareable) {
                val = ((Shareable)val).copy();
            } else if (val instanceof Map) {
                val = new JsonObject((Map)val).copy(copier);
            } else if (val instanceof List) {
                val = new JsonArray((List)val).copy(copier);
            } else if (!(val instanceof byte[] || val instanceof Instant || val instanceof Enum)) {
                val = copier.apply(val);
            }
        }
        return val;
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static int hashCode(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return Double.hashCode(((Number)value).doubleValue());
        }
        return value.hashCode();
    }

    public static boolean compare(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1.getClass() == o2.getClass()) {
                return o1.equals(o2);
            }
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return JsonUtil.compareNumbers(n1, n2);
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence && o1.getClass() != o2.getClass()) {
            return Objects.equals(o1.toString(), o2.toString());
        }
        return Objects.equals(o1, o2);
    }

    private static boolean compareNumbers(Number n1, Number n2) {
        if (JsonUtil.isDecimalNumber(n1) && JsonUtil.isDecimalNumber(n2)) {
            return n1.doubleValue() == n2.doubleValue();
        }
        if (JsonUtil.isWholeNumber(n1) && JsonUtil.isWholeNumber(n2)) {
            return n1.longValue() == n2.longValue();
        }
        if (JsonUtil.isWholeNumber(n1) && JsonUtil.isDecimalNumber(n2) || JsonUtil.isDecimalNumber(n1) && JsonUtil.isWholeNumber(n2)) {
            return n1.doubleValue() == n2.doubleValue();
        }
        if (JsonUtil.isWholeNumber(n1)) {
            return n1.longValue() == n2.longValue();
        }
        return n1.doubleValue() == n2.doubleValue();
    }

    private static boolean isWholeNumber(Number thisValue) {
        return thisValue instanceof Integer || thisValue instanceof Long;
    }

    private static boolean isDecimalNumber(Number thisValue) {
        return thisValue instanceof Float || thisValue instanceof Double;
    }
}

