/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Timer;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientBuilder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.transport.Transport;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@VertxGen
public interface Vertx
extends Measured {
    public static VertxBuilder builder() {
        return new VertxBuilder(){
            private VertxOptions options;
            private ClusterManager clusterManager;
            private VertxMetricsFactory metricsFactory;
            private VertxTracerFactory tracerFactory;
            private Transport transport;

            @Override
            public VertxBuilder with(VertxOptions options) {
                this.options = options;
                return this;
            }

            @Override
            public VertxBuilder withMetrics(VertxMetricsFactory factory) {
                this.metricsFactory = factory;
                return this;
            }

            @Override
            public VertxBuilder withTracer(VertxTracerFactory factory) {
                this.tracerFactory = factory;
                return this;
            }

            @Override
            public VertxBuilder withClusterManager(ClusterManager clusterManager) {
                this.clusterManager = clusterManager;
                return this;
            }

            @Override
            public VertxBuilder withTransport(Transport transport) {
                this.transport = transport;
                return this;
            }

            private VertxBootstrap bootstrap() {
                VertxBootstrap bootstrap = VertxBootstrap.create();
                if (this.options != null) {
                    bootstrap.options(this.options);
                }
                bootstrap.metricsFactory(this.metricsFactory);
                bootstrap.tracerFactory(this.tracerFactory);
                Transport tr = this.transport;
                if (tr == null && this.options != null && this.options.getPreferNativeTransport()) {
                    tr = Transport.nativeTransport();
                }
                if (tr == null) {
                    tr = Transport.NIO;
                }
                bootstrap.transport(tr.implementation());
                return bootstrap;
            }

            @Override
            public Vertx build() {
                return this.bootstrap().init().vertx();
            }

            @Override
            public Future<Vertx> buildClustered() {
                return this.bootstrap().clusterManager(this.clusterManager).init().clusteredVertx();
            }
        };
    }

    public static Vertx vertx() {
        return Vertx.vertx(new VertxOptions());
    }

    public static Vertx vertx(VertxOptions options) {
        return Vertx.builder().with(options).build();
    }

    public static Future<Vertx> clusteredVertx(VertxOptions options) {
        return Vertx.builder().with(options).buildClustered();
    }

    public static @Nullable Context currentContext() {
        return VertxImpl.currentContext(Thread.currentThread());
    }

    public Context getOrCreateContext();

    public NetServer createNetServer(NetServerOptions var1);

    default public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    public NetClient createNetClient(NetClientOptions var1);

    default public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    public HttpServer createHttpServer(HttpServerOptions var1);

    default public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    default public WebSocketClient createWebSocketClient() {
        return this.createWebSocketClient(new WebSocketClientOptions());
    }

    public WebSocketClient createWebSocketClient(WebSocketClientOptions var1);

    public HttpClientBuilder httpClientBuilder();

    default public HttpClientAgent createHttpClient(HttpClientOptions clientOptions, PoolOptions poolOptions) {
        return this.httpClientBuilder().with(clientOptions).with(poolOptions).build();
    }

    default public HttpClientAgent createHttpClient(HttpClientOptions clientOptions) {
        return this.createHttpClient(clientOptions, new PoolOptions());
    }

    default public HttpClientAgent createHttpClient(PoolOptions poolOptions) {
        return this.createHttpClient(new HttpClientOptions(), poolOptions);
    }

    default public HttpClientAgent createHttpClient() {
        return this.createHttpClient(new HttpClientOptions(), new PoolOptions());
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions var1);

    default public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @CacheReturn
    public FileSystem fileSystem();

    @CacheReturn
    public EventBus eventBus();

    public DnsClient createDnsClient(int var1, String var2);

    public DnsClient createDnsClient();

    public DnsClient createDnsClient(DnsClientOptions var1);

    @CacheReturn
    public SharedData sharedData();

    default public Timer timer(long delay) {
        return this.timer(delay, TimeUnit.MILLISECONDS);
    }

    default public Timer timer(long delay, TimeUnit unit) {
        ContextInternal ctx = (ContextInternal)this.getOrCreateContext();
        return ctx.timer(delay, unit);
    }

    public long setTimer(long var1, Handler<Long> var3);

    default public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setPeriodic(delay, delay, handler);
    }

    public long setPeriodic(long var1, long var3, Handler<Long> var5);

    public boolean cancelTimer(long var1);

    public void runOnContext(Handler<Void> var1);

    public Future<Void> close();

    @GenIgnore(value={"permitted-type"})
    default public Future<String> deployVerticle(Deployable verticle) {
        return this.deployVerticle(verticle, new DeploymentOptions());
    }

    @GenIgnore(value={"permitted-type"})
    default public Future<String> deployVerticle(Deployable verticle, DeploymentOptions options) {
        return this.deployVerticle(() -> verticle, options);
    }

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Supplier<? extends Deployable> var1, DeploymentOptions var2);

    @GenIgnore
    public Future<String> deployVerticle(Class<? extends Deployable> var1, DeploymentOptions var2);

    default public Future<String> deployVerticle(String name) {
        return this.deployVerticle(name, new DeploymentOptions());
    }

    public Future<String> deployVerticle(String var1, DeploymentOptions var2);

    public Future<Void> undeploy(String var1);

    public Set<String> deploymentIDs();

    @GenIgnore(value={"permitted-type"})
    public void registerVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public void unregisterVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public Set<VerticleFactory> verticleFactories();

    public boolean isClustered();

    @GenIgnore(value={"permitted-type"})
    default public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        Context context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    @GenIgnore(value={"permitted-type"})
    default public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    public WorkerExecutor createSharedWorkerExecutor(String var1);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    @CacheReturn
    public boolean isNativeTransportEnabled();

    @CacheReturn
    public Throwable unavailableNativeTransportCause();

    @Fluent
    public Vertx exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

