/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.faketracer.FakeTracer;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class TracerTest
extends VertxTestBase {
    private FakeTracer tracer = new FakeTracer();

    @Override
    protected VertxTracer getTracer() {
        return this.tracer;
    }

    @Test
    public void testClose() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.assertEquals(0L, this.tracer.closeCount());
        this.vertx.close(ar -> latch.countDown());
        this.awaitLatch(latch);
        this.assertEquals(1L, this.tracer.closeCount());
    }

    @Test
    public void testWorkerExecutor() {
        WorkerExecutor exec = this.vertx.createSharedWorkerExecutor("exec");
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ContextInternal duplicate = ctx.duplicate();
        duplicate.runOnContext(v -> exec.executeBlocking(Promise::complete, this.onSuccess(res -> this.testComplete())));
        this.await();
    }
}

