/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.LockInternal;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class AsynchronousLockTest
extends VertxTestBase {
    protected Vertx getVertx() {
        return this.vertx;
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLock(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLock("foo", null));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLockWithTimeout(null, 1L, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLockWithTimeout("foo", 1L, null));
        TestUtils.assertIllegalArgumentException(() -> this.getVertx().sharedData().getLockWithTimeout("foo", -1L, ar -> {}));
    }

    @Test
    public void testAcquire() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            Lock lock = (Lock)ar.result();
            this.vertx.setTimer(1000L, tid -> lock.release());
            this.getVertx().sharedData().getLock("foo", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAcquireOnSameEventLoop() {
        Vertx vertx = this.getVertx();
        Context context = vertx.getOrCreateContext();
        SharedData sharedData = vertx.sharedData();
        AtomicReference start = new AtomicReference();
        context.runOnContext(v -> sharedData.getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            start.set(System.currentTimeMillis());
            Lock lock = (Lock)ar.result();
            vertx.setTimer(1000L, tid -> lock.release());
            context.runOnContext(v2 -> sharedData.getLock("foo", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - (Long)start.get() >= 1000L);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testAcquireDifferentLocksOnSameEventLoop() {
        Vertx vertx = this.getVertx();
        Context context = vertx.getOrCreateContext();
        SharedData sharedData = vertx.sharedData();
        AtomicInteger stage = new AtomicInteger();
        context.runOnContext(v -> sharedData.getLock("foo", this.onSuccess(foo -> {
            this.assertTrue(stage.compareAndSet(0, 1));
            sharedData.getLock("foo", this.onSuccess(foo1 -> {
                this.assertEquals(2L, stage.get());
                foo1.release();
                this.testComplete();
            }));
            sharedData.getLock("bar", this.onSuccess(bar -> {
                this.assertTrue(stage.compareAndSet(1, 2));
                foo.release();
                bar.release();
            }));
        })));
        this.await();
    }

    @Test
    public void testAcquireOnExecuteBlocking() {
        Vertx vertx = this.getVertx();
        SharedData sharedData = vertx.sharedData();
        AtomicReference start = new AtomicReference();
        vertx.executeBlocking(future -> {
            CountDownLatch acquireLatch = new CountDownLatch(1);
            AtomicReference lockReference = new AtomicReference();
            sharedData.getLock("foo", ar -> {
                lockReference.set(ar);
                acquireLatch.countDown();
            });
            try {
                this.awaitLatch(acquireLatch);
                AsyncResult ar2 = (AsyncResult)lockReference.get();
                if (ar2.succeeded()) {
                    future.complete(ar2.result());
                } else {
                    future.fail(ar2.cause());
                }
            }
            catch (InterruptedException e) {
                future.fail((Throwable)e);
            }
        }, ar -> {
            if (ar.succeeded()) {
                start.set(System.currentTimeMillis());
                vertx.setTimer(1000L, tid -> ((Lock)ar.result()).release());
                vertx.executeBlocking(future -> {
                    CountDownLatch acquireLatch = new CountDownLatch(1);
                    AtomicReference lockReference = new AtomicReference();
                    sharedData.getLock("foo", ar2 -> {
                        lockReference.set(ar2);
                        acquireLatch.countDown();
                    });
                    try {
                        this.awaitLatch(acquireLatch);
                        AsyncResult ar3 = (AsyncResult)lockReference.get();
                        if (ar3.succeeded()) {
                            future.complete(ar3.result());
                        } else {
                            future.fail(ar3.cause());
                        }
                    }
                    catch (InterruptedException e) {
                        future.fail((Throwable)e);
                    }
                }, ar4 -> {
                    if (ar4.succeeded()) {
                        this.assertTrue(System.currentTimeMillis() - (Long)start.get() >= 1000L);
                        this.testComplete();
                    } else {
                        this.fail(ar4.cause());
                    }
                });
            } else {
                this.fail(ar.cause());
            }
        });
        this.await();
    }

    @Test
    public void testAcquireDifferentLocks() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            Lock lock = (Lock)ar.result();
            this.getVertx().sharedData().getLock("bar", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start < 2000L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAcquireTimeout() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            this.getVertx().sharedData().getLockWithTimeout("foo", 1000L, ar2 -> {
                this.assertFalse(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testReleaseTwice() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        AtomicInteger count = new AtomicInteger();
        this.getVertx().sharedData().getLock("foo", this.onSuccess(lock1 -> {
            count.incrementAndGet();
            for (int i = 0; i < 2; ++i) {
                this.getVertx().sharedData().getLockWithTimeout("foo", 10L, ar -> {
                    if (ar.succeeded()) {
                        count.incrementAndGet();
                    }
                    latch.countDown();
                });
            }
            lock1.release();
            lock1.release();
        }));
        this.awaitLatch(latch);
        this.assertEquals(2L, count.get());
    }

    @Test
    public void testNoWorkerStarvation() {
        this.waitFor(5);
        this.getVertx().deployVerticle(() -> new AbstractVerticle(){

            public void start() throws Exception {
                this.vertx.sharedData().getLock("foo", AsynchronousLockTest.this.onSuccess(lock -> this.vertx.setTimer(10L, l -> {
                    lock.release();
                    AsynchronousLockTest.this.complete();
                })));
            }
        }, new DeploymentOptions().setInstances(5).setWorkerPoolName("bar").setWorkerPoolSize(1));
        this.await();
    }

    @Test
    public void evictTimedOutWaiters() {
        int numWaiters = 10;
        SharedData sharedData = this.vertx.sharedData();
        sharedData.getLocalLock("foo", this.onSuccess(lock -> {
            ArrayList<Future> locks = new ArrayList<Future>();
            for (int i = 0; i < numWaiters; ++i) {
                locks.add(sharedData.getLocalLockWithTimeout("foo", 200L));
            }
            LockInternal lockInternal = (LockInternal)lock;
            this.assertEquals(numWaiters, lockInternal.waiters());
            CompositeFuture.join(locks).onComplete(cf -> {
                this.assertEquals(0L, lockInternal.waiters());
                lock.release();
                this.testComplete();
            });
        }));
        this.await();
    }
}

