/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.parsetools;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.streams.ReadStream;

class FakeStream
implements ReadStream<Buffer> {
    private long demand = Long.MAX_VALUE;
    private Handler<Buffer> eventHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private volatile int pauseCount;
    private volatile int resumeCount;

    FakeStream() {
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        this.eventHandler = handler;
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        Arguments.require((amount > 0L ? 1 : 0) != 0, (String)"Fetch amount must be > 0L");
        this.demand += amount;
        if (this.demand < 0L) {
            this.demand = Long.MAX_VALUE;
        }
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.demand = 0L;
        ++this.pauseCount;
        return this;
    }

    public ReadStream<Buffer> resume() {
        ++this.resumeCount;
        return this.fetch(Long.MAX_VALUE);
    }

    public ReadStream<Buffer> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    boolean isPaused() {
        return this.demand == 0L;
    }

    void handle(String s) {
        this.handle(Buffer.buffer((String)s));
    }

    void handle(Buffer buff) {
        if (this.demand == 0L) {
            throw new IllegalStateException();
        }
        if (this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        this.eventHandler.handle((Object)buff);
    }

    void fail(Throwable err) {
        this.exceptionHandler.handle((Object)err);
    }

    void end() {
        this.endHandler.handle(null);
    }

    public int pauseCount() {
        return this.pauseCount;
    }

    public int resumeCount() {
        return this.resumeCount;
    }
}

