/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.Context;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NetAllocatorsTest
extends VertxTestBase {
    private SocketAddress testAddress;
    private NetServer server;
    private NetClient client;
    private File tmp;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (USE_DOMAIN_SOCKETS) {
            this.assertTrue("Native transport not enabled", USE_NATIVE_TRANSPORT);
            this.tmp = TestUtils.tmpFile(".sock");
            this.testAddress = SocketAddress.domainSocketAddress((String)this.tmp.getAbsolutePath());
        } else {
            this.testAddress = SocketAddress.inetSocketAddress((int)1234, (String)"localhost");
        }
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
        this.server = this.vertx.createNetServer();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host1\n127.0.0.1 host2.com\n127.0.0.1 example.com"));
        return options;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.tmp != null) {
            this.tmp.delete();
        }
        super.tearDown();
    }

    @Test
    public void testServerAllocatorNoSSL() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
        this.testServerAllocator(new HttpClientOptions(), false, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, false);
    }

    @Test
    public void testHeapPoolingServerAllocatorJdkSSL() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions().setPooledHeapBuffers(true)).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()));
        this.testServerAllocator(new HttpClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()), true, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, false);
    }

    @Test
    public void testServerAllocatorJdkSSL() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()));
        this.testServerAllocator(new HttpClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()), true, VertxByteBufAllocator.UNPOOLED_ALLOCATOR, (ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE, true);
    }

    @Test
    public void testServerAllocatorOpenSSL() throws Exception {
        Assume.assumeTrue((boolean)OpenSSLEngineOptions.isAvailable());
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()));
        this.testServerAllocator(new HttpClientOptions().setSsl(true).setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()), true, VertxByteBufAllocator.POOLED_ALLOCATOR, (ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE, false);
    }

    private void testServerAllocator(HttpClientOptions clientOptions, boolean expectSSL, final ByteBufAllocator bufferAllocator, final ByteBufAllocator channelAllocator, final boolean expectHeapBuffer) throws Exception {
        this.waitFor(2);
        this.server.connectHandler(so -> {
            NetSocketInternal internal = (NetSocketInternal)so;
            this.assertEquals(expectSSL, internal.isSsl());
            ChannelHandlerContext chctx = internal.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpServerCodec());
            pipeline.addBefore("http", "raw", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    NetAllocatorsTest.this.assertTrue(msg instanceof ByteBuf);
                    ByteBuf byteBuf = (ByteBuf)msg;
                    NetAllocatorsTest.this.assertSame(bufferAllocator, byteBuf.alloc());
                    NetAllocatorsTest.this.assertSame(channelAllocator, ctx.channel().config().getAllocator());
                    NetAllocatorsTest.this.assertTrue(expectHeapBuffer == byteBuf.hasArray());
                    super.channelRead(ctx, msg);
                }
            });
            internal.handler(buff -> this.fail());
            internal.messageHandler(obj -> {
                if (obj instanceof LastHttpContent) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)StandardCharsets.UTF_8));
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"11");
                    internal.writeMessage((Object)response, this.onSuccess(v -> this.complete()));
                }
            });
        });
        this.startServer(SocketAddress.inetSocketAddress((int)1234, (String)"localhost"));
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        client.request(io.vertx.core.http.HttpMethod.GET, 1234, "localhost", "/somepath", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.body(this.onSuccess(body -> {
                this.assertEquals("Hello World", body.toString());
                this.complete();
            }));
        }))));
        this.await();
    }

    @Test
    public void testClientAllocatorNoSSL() throws Exception {
        this.testClientAllocator(new HttpServerOptions().setHost("localhost").setPort(1234), false, VertxByteBufAllocator.POOLED_ALLOCATOR, (ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE, false);
    }

    @Test
    public void testHeapPoolingClientAllocatorJdkSSL() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions().setPooledHeapBuffers(true)).setHostnameVerificationAlgorithm("").setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
        this.testClientAllocator(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, false);
    }

    @Test
    public void testClientAllocatorJdkSSL() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()).setHostnameVerificationAlgorithm("").setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
        this.testClientAllocator(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true, VertxByteBufAllocator.UNPOOLED_ALLOCATOR, (ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE, true);
    }

    @Test
    public void testClientAllocatorOpenSSL() throws Exception {
        Assume.assumeTrue((boolean)OpenSSLEngineOptions.isAvailable());
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setSsl(true).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions()).setHostnameVerificationAlgorithm("").setTrustStoreOptions((JksOptions)Trust.SERVER_JKS.get()));
        this.testClientAllocator(new HttpServerOptions().setHost("localhost").setPort(1234).setSsl(true).setKeyStoreOptions((JksOptions)Cert.SERVER_JKS.get()), true, VertxByteBufAllocator.POOLED_ALLOCATOR, (ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE, false);
    }

    private void testClientAllocator(HttpServerOptions options, boolean expectSSL, final ByteBufAllocator expectedBufferAllocator, final ByteBufAllocator expectedChannelAllocator, final boolean expectHeapBuffer) throws Exception {
        this.waitFor(2);
        HttpServer server = this.vertx.createHttpServer(options);
        server.requestHandler(req -> req.response().end("Hello World"));
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.connect(1234, "localhost", this.onSuccess(so -> {
            NetSocketInternal soInt = (NetSocketInternal)so;
            this.assertEquals(expectSSL, soInt.isSsl());
            ChannelHandlerContext chctx = soInt.channelHandlerContext();
            ChannelPipeline pipeline = chctx.pipeline();
            pipeline.addBefore("handler", "http", (ChannelHandler)new HttpClientCodec());
            pipeline.addBefore("http", "raw", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    NetAllocatorsTest.this.assertTrue(msg instanceof ByteBuf);
                    ByteBuf byteBuf = (ByteBuf)msg;
                    NetAllocatorsTest.this.assertSame(expectedBufferAllocator, byteBuf.alloc());
                    NetAllocatorsTest.this.assertSame(expectedChannelAllocator, ctx.channel().config().getAllocator());
                    NetAllocatorsTest.this.assertTrue(expectHeapBuffer == byteBuf.hasArray());
                    super.channelRead(ctx, msg);
                    NetAllocatorsTest.this.complete();
                }
            });
            soInt.handler(buff -> this.fail());
            soInt.writeMessage((Object)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/somepath"), this.onSuccess(v -> this.complete()));
        }));
        this.await();
    }

    protected void startServer(SocketAddress remoteAddress) throws Exception {
        this.startServer(remoteAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(SocketAddress remoteAddress, Context context) throws Exception {
        this.startServer(remoteAddress, context, this.server);
    }

    protected void startServer(SocketAddress remoteAddress, Context context, NetServer server) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        context.runOnContext(v -> server.listen(remoteAddress, this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
    }

    protected void startServer() throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext());
    }

    protected void startServer(NetServer server) throws Exception {
        this.startServer(this.testAddress, this.vertx.getOrCreateContext(), server);
    }

    protected void startServer(Context context) throws Exception {
        this.startServer(this.testAddress, context, this.server);
    }

    protected void startServer(Context context, NetServer server) throws Exception {
        this.startServer(this.testAddress, context, server);
    }
}

