/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.net.impl.HostAndPortImpl;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=2)
public class HostAndPortBenchmark {
    @Param(value={"192.168.0.1:8080"})
    private String host;

    @Setup
    public void setup() {
    }

    @Benchmark
    public int parseIPv4Address() {
        String host = this.host;
        return HostAndPortImpl.parseIPv4Address((String)host, (int)0, (int)host.length());
    }

    @Benchmark
    public int parseHost() {
        String host = this.host;
        return HostAndPortImpl.parseHost((String)host, (int)0, (int)host.length());
    }

    @Benchmark
    public HostAndPortImpl parseAuthority() {
        return HostAndPortImpl.parseAuthority((String)this.host, (int)-1);
    }

    @Benchmark
    public boolean isValidAuthority() {
        return HostAndPortImpl.isValidAuthority((String)this.host);
    }
}

