/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggingBackendSelectionTest {
    private ClassLoader originalTccl;
    private TestClassLoader testClassLoader;

    @Before
    public void setup() {
        this.originalTccl = Thread.currentThread().getContextClassLoader();
        this.testClassLoader = new TestClassLoader(this.originalTccl);
        Thread.currentThread().setContextClassLoader(this.testClassLoader);
    }

    @After
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalTccl);
        System.clearProperty("vertx.logger-delegate-factory-class-name");
    }

    @Test
    public void syspropPriority() throws Exception {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.Log4j2LogDelegateFactory");
        Assert.assertEquals((Object)"Log4j2", (Object)this.loggingBackend());
    }

    @Test
    public void vertxJulFilePriority() throws Exception {
        Assert.assertEquals((Object)"JUL", (Object)this.loggingBackend());
    }

    @Test
    public void SLF4JPriority() throws Exception {
        this.testClassLoader.hideVertxJulFile = true;
        Assert.assertEquals((Object)"SLF4J", (Object)this.loggingBackend());
    }

    @Test
    public void Log4j2Priority() throws Exception {
        this.testClassLoader.hideVertxJulFile = true;
        this.testClassLoader.hiddenPackages.add("org.slf4j");
        Assert.assertEquals((Object)"Log4j2", (Object)this.loggingBackend());
    }

    @Test
    public void JULDefault() throws Exception {
        this.testClassLoader.hideVertxJulFile = true;
        this.testClassLoader.hiddenPackages.add("org.slf4j");
        this.testClassLoader.hiddenPackages.add("org.apache.logging");
        Assert.assertEquals((Object)"JUL", (Object)this.loggingBackend());
    }

    private String loggingBackend() throws Exception {
        Class<?> factoryClass = this.testClassLoader.loadClass("io.vertx.core.impl.logging.LoggerFactory");
        Method factoryMethod = factoryClass.getMethod("getLogger", String.class);
        Object loggerAdapter = factoryMethod.invoke(null, "whatever");
        Field adaptedField = loggerAdapter.getClass().getDeclaredField("adapted");
        adaptedField.setAccessible(true);
        Object adapted = adaptedField.get(loggerAdapter);
        String backendClass = adapted.getClass().getSimpleName();
        return backendClass.substring(0, backendClass.indexOf("LogDelegate"));
    }

    private static class TestClassLoader
    extends ClassLoader {
        boolean hideVertxJulFile;
        Set<String> hiddenPackages = new HashSet<String>();

        TestClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            URL url;
            if (this.hiddenPackages.stream().anyMatch(name::startsWith)) {
                throw new ClassNotFoundException(name);
            }
            if (!name.startsWith("io.vertx.core.impl.logging")) {
                if (!name.startsWith("io.vertx.core.logging")) return super.loadClass(name, resolve);
            }
            if ((url = this.getResource(name.replace('.', '/') + ".class")) == null) {
                throw new ClassNotFoundException(name);
            }
            try (InputStream in = url.openStream();){
                int l;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buff = new byte[256];
                while ((l = in.read(buff)) != -1) {
                    baos.write(buff, 0, l);
                }
                byte[] bytes = baos.toByteArray();
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                Class<?> clazz2 = clazz;
                return clazz2;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }

        @Override
        public URL getResource(String name) {
            if (this.hideVertxJulFile && "vertx-default-jul-logging.properties".equals(name)) {
                return null;
            }
            return super.getResource(name);
        }
    }
}

