/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.impl.Utils;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExecUtilsTest {
    private Field field;
    private String originalOsName;

    @Before
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        this.field = ExecUtils.class.getDeclaredField("osName");
        this.field.setAccessible(true);
        this.originalOsName = (String)this.field.get(null);
    }

    @After
    public void tearDown() throws IllegalAccessException {
        this.set(this.originalOsName);
    }

    private void set(String value) throws IllegalAccessException {
        this.field.setAccessible(true);
        this.field.set(null, value);
    }

    @Test
    public void testAddArgument() throws Exception {
        ArrayList args = new ArrayList();
        ExecUtils.addArgument(args, (String)"hello");
        ExecUtils.addArgument(args, (String)"-foo");
        ExecUtils.addArgument(args, (String)"--bar");
        ExecUtils.addArgument(args, (String)"--baz=hello");
        ExecUtils.addArgument(args, (String)"with spaces");
        ExecUtils.addArgument(args, (String)"with'single'_quotes");
        ExecUtils.addArgument(args, (String)"with\"double\"quotes");
        ExecUtils.addArgument(args, (String)"with \"double\" quotes and spaces");
        ExecUtils.addArgument(args, (String)"with 'single' quotes and spaces");
        ExecUtils.addArgument(args, (String)"'wrapped_in_single_quotes'");
        ExecUtils.addArgument(args, (String)"\"wrapped_in_double_quotes\"");
        Assertions.assertThat(args).contains((Object[])new String[]{"hello", "-foo", "--bar", "--baz=hello", "\"with spaces\"", "\"with'single'_quotes\"", Utils.isWindows() ? "\"with\\\"double\\\"quotes\"" : "'with\"double\"quotes'", Utils.isWindows() ? "\"with \\\"double\\\" quotes and spaces\"" : "'with \"double\" quotes and spaces'", "\"with 'single' quotes and spaces\"", "wrapped_in_single_quotes", "wrapped_in_double_quotes"});
    }

    @Test
    public void testIsWindows() throws IllegalAccessException {
        this.set("windows 98");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows me");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows nt");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows 2000");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows xp");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows 2003");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows vista");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows 7");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows 8");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
        this.set("windows nt (unknown)");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isTrue();
    }

    @Test
    public void testIsNotWindows() throws IllegalAccessException {
        this.set("mac os x");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isFalse();
        this.set("linux");
        Assertions.assertThat((boolean)ExecUtils.isWindows()).isFalse();
    }
}

