/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.test.core.VertxTestBase;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.junit.Assume;
import org.junit.Test;

public class VirtualThreadHttpTest
extends VertxTestBase {
    private VertxInternal vertx;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)((VertxTestBase)this).vertx;
    }

    @Test
    public void testHttpClient1() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> req.response().end("Hello World"));
        server.listen(8088, "localhost").toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            HttpClient client = this.vertx.createHttpClient();
            for (int i = 0; i < 100; ++i) {
                HttpClientRequest req = (HttpClientRequest)Future.await((Future)client.request(HttpMethod.GET, 8088, "localhost", "/"));
                HttpClientResponse resp = (HttpClientResponse)Future.await((Future)req.send());
                Buffer body = (Buffer)Future.await((Future)resp.body());
                String bodyString = body.toString(StandardCharsets.UTF_8);
                this.assertEquals("Hello World", bodyString);
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHttpClient2() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        this.waitFor(100);
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> req.response().end("Hello World"));
        server.listen(8088, "localhost").toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        HttpClient client = this.vertx.createHttpClient();
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            for (int i = 0; i < 100; ++i) {
                client.request(HttpMethod.GET, 8088, "localhost", "/").onSuccess(req -> {
                    HttpClientResponse resp = (HttpClientResponse)Future.await((Future)req.send());
                    StringBuffer body = new StringBuffer();
                    resp.handler(buff -> body.append(buff.toString()));
                    resp.endHandler(v2 -> {
                        this.assertEquals("Hello World", body.toString());
                        this.complete();
                    });
                });
            }
        });
        try {
            this.await();
        }
        finally {
            server.close().toCompletionStage().toCompletableFuture().get();
            client.close().toCompletionStage().toCompletableFuture().get();
        }
    }

    @Test
    public void testHttpClientTimeout() throws Exception {
        Assume.assumeTrue((boolean)this.isVirtualThreadAvailable());
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> {});
        server.listen(8088, "localhost").toCompletionStage().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        this.vertx.createVirtualThreadContext().runOnContext(v -> {
            HttpClient client = this.vertx.createHttpClient();
            ContextInternal ctx = this.vertx.getOrCreateContext();
            HttpClientRequest req = (HttpClientRequest)Future.await((Future)client.request(HttpMethod.GET, 8088, "localhost", "/"));
            PromiseInternal promise = ctx.promise();
            req.send().onComplete((Handler)promise);
            Exception failure = new Exception("Too late");
            this.vertx.setTimer(500L, id -> promise.tryFail((Throwable)failure));
            try {
                HttpClientResponse httpClientResponse = (HttpClientResponse)Future.await((Future)promise.future());
            }
            catch (Exception e) {
                this.assertSame(failure, e);
                this.testComplete();
            }
        });
        this.await();
    }
}

