/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.core.file.ZipFileResolverTest;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.AssertionFailedError;
import org.junit.Assert;

public class NestedRootJarResolverTest
extends FileResolverTestBase {
    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File nestedFiles = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "nestedroot.jar", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)nestedFiles.delete());
        ZipFileResolverTest.getFiles(baseDir, nestedFiles, new Function<OutputStream, ZipOutputStream>(){

            @Override
            public ZipOutputStream apply(OutputStream outputStream) {
                ZipOutputStream zip = new ZipOutputStream(outputStream);
                try {
                    zip.putNextEntry(new ZipEntry("nested-inf/classes/"));
                    zip.closeEntry();
                }
                catch (IOException e) {
                    throw new AssertionFailedError();
                }
                return zip;
            }
        }, name -> new ZipEntry("nested-inf/classes/" + name));
        final URL webrootURL = nestedFiles.toURI().toURL();
        return new ClassLoader(Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                try {
                    if (name.equals("nested-inf/classes")) {
                        return new URL("jar:" + webrootURL + "!/nested-inf/classes");
                    }
                    if (name.startsWith("webroot")) {
                        return new URL("jar:" + webrootURL + "!/nested-inf/classes!/" + name);
                    }
                    if (name.equals("afile.html") || name.equals("afile with spaces.html") || name.equals("afilewithspaceatend ")) {
                        return new URL("jar:" + webrootURL + "!/nested-inf/classes!/" + name);
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                return super.getResource(name);
            }
        };
    }
}

