/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.spi.json.JsonCodec;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
public class JsonEncodeBenchmark
extends BenchmarkBase {
    private JsonObject small;
    private JsonObject wide;
    private JsonObject deep;
    private JsonCodec jacksonCodec;
    private JsonCodec databindCodec;

    @Setup
    public void setup() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.small = this.loadJson(classLoader.getResource("small_bench.json"));
        this.wide = this.loadJson(classLoader.getResource("wide_bench.json"));
        this.deep = this.loadJson(classLoader.getResource("deep_bench.json"));
        this.jacksonCodec = new JacksonCodec();
        this.databindCodec = new DatabindCodec();
    }

    private JsonObject loadJson(URL url) {
        try {
            return new JsonObject((Map)new ObjectMapper().readValue(url, Map.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    public void smallStringJackson(Blackhole blackhole) throws Exception {
        this.stringJackson(this.small, blackhole);
    }

    @Benchmark
    public void smallStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.small, blackhole);
    }

    @Benchmark
    public void wideStringJackson(Blackhole blackhole) throws Exception {
        this.stringJackson(this.wide, blackhole);
    }

    @Benchmark
    public void wideStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.wide, blackhole);
    }

    @Benchmark
    public void deepStringJackson(Blackhole blackhole) throws Exception {
        this.stringJackson(this.deep, blackhole);
    }

    @Benchmark
    public void deepStringDatabind(Blackhole blackhole) throws Exception {
        this.stringDatabind(this.deep, blackhole);
    }

    private void stringJackson(JsonObject jsonObject, Blackhole blackhole) throws Exception {
        blackhole.consume((Object)jsonObject.encode());
    }

    private void stringDatabind(JsonObject jsonObject, Blackhole blackhole) throws Exception {
        blackhole.consume((Object)this.databindCodec.toString((Object)jsonObject));
    }

    @Benchmark
    public void smallBufferJackson(Blackhole blackhole) throws Exception {
        this.bufferJackson(this.small, blackhole);
    }

    @Benchmark
    public void smallBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.small, blackhole);
    }

    @Benchmark
    public void deepBufferJackson(Blackhole blackhole) throws Exception {
        this.bufferJackson(this.deep, blackhole);
    }

    @Benchmark
    public void deepBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.deep, blackhole);
    }

    @Benchmark
    public void wideBufferJackson(Blackhole blackhole) throws Exception {
        this.bufferJackson(this.wide, blackhole);
    }

    @Benchmark
    public void wideBufferDatabind(Blackhole blackhole) throws Exception {
        this.bufferDatabind(this.wide, blackhole);
    }

    private void bufferJackson(JsonObject jsonObject, Blackhole blackhole) throws Exception {
        blackhole.consume((Object)jsonObject.toBuffer());
    }

    private void bufferDatabind(JsonObject jsonObject, Blackhole blackhole) throws Exception {
        blackhole.consume((Object)this.jacksonCodec.toBuffer((Object)jsonObject));
    }
}

