/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=400, timeUnit=TimeUnit.MILLISECONDS)
public class HeadersValidationBenchmark
extends BenchmarkBase {
    @Param(value={"true", "false"})
    public boolean ascii;
    private CharSequence[] headerNames;
    private CharSequence[] headerValues;
    private static final DefaultHeaders.NameValidator<CharSequence> nettyNameValidator = DefaultHttpHeadersFactory.headersFactory().getNameValidator();
    private static final DefaultHeaders.ValueValidator<CharSequence> nettyValueValidator = DefaultHttpHeadersFactory.headersFactory().getValueValidator();
    private static final Consumer<CharSequence> vertxNameValidator = HttpUtils::validateHeaderName;
    private static final Consumer<CharSequence> vertxValueValidator = HttpUtils::validateHeaderValue;

    @Setup
    public void setup() {
        int i;
        this.headerNames = new CharSequence[4];
        this.headerValues = new CharSequence[4];
        this.headerNames[0] = HttpHeaders.CONTENT_TYPE;
        this.headerValues[0] = HttpHeaders.createOptimized((String)"text/plain");
        this.headerNames[1] = HttpHeaders.CONTENT_LENGTH;
        this.headerValues[1] = HttpHeaders.createOptimized((String)"20");
        this.headerNames[2] = HttpHeaders.SERVER;
        this.headerValues[2] = HttpHeaders.createOptimized((String)"vert.x");
        this.headerNames[3] = HttpHeaders.DATE;
        this.headerValues[3] = HttpHeaders.createOptimized((String)HeadersUtils.DATE_FORMAT.format(new Date(0L)));
        if (!this.ascii) {
            for (i = 0; i < this.headerNames.length; ++i) {
                this.headerNames[i] = this.headerNames[i].toString();
            }
        }
        if (!this.ascii) {
            for (i = 0; i < this.headerValues.length; ++i) {
                this.headerValues[i] = this.headerValues[i].toString();
            }
        }
    }

    @Benchmark
    public void validateNameNetty() {
        for (CharSequence headerName : this.headerNames) {
            this.nettyNameValidation(headerName);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private void nettyNameValidation(CharSequence headerName) {
        nettyNameValidator.validateName((Object)headerName);
    }

    @Benchmark
    public void validateNameVertx() {
        for (CharSequence headerName : this.headerNames) {
            this.vertxNameValidation(headerName);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private void vertxNameValidation(CharSequence headerName) {
        vertxNameValidator.accept(headerName);
    }

    @Benchmark
    public void validateValueNetty() {
        for (CharSequence headerValue : this.headerValues) {
            this.nettyValueValidation(headerValue);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private void nettyValueValidation(CharSequence headerValue) {
        nettyValueValidator.validate((Object)headerValue);
    }

    @Benchmark
    public void validateValueVertx() {
        for (CharSequence headerValue : this.headerValues) {
            this.vertxValueValidation(headerValue);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private void vertxValueValidation(CharSequence headerValue) {
        vertxValueValidator.accept(headerValue);
    }
}

