/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.ServiceHelper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.jackson.JacksonFactory;
import io.vertx.core.spi.JsonFactory;
import io.vertx.core.spi.json.JsonCodec;

public class Json {
    public static final JsonCodec CODEC = JsonFactory.INSTANCE.codec();

    public static JsonFactory load() {
        JsonFactory factory = ServiceHelper.loadFactoryOrNull(JsonFactory.class);
        if (factory == null) {
            factory = JacksonFactory.INSTANCE;
        }
        return factory;
    }

    public static String encode(Object obj) throws EncodeException {
        return CODEC.toString(obj);
    }

    public static Buffer encodeToBuffer(Object obj) throws EncodeException {
        return CODEC.toBuffer(obj);
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        return CODEC.toString(obj, true);
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        return CODEC.fromString(str, clazz);
    }

    public static Object decodeValue(String str) throws DecodeException {
        return Json.decodeValue(str, Object.class);
    }

    public static Object decodeValue(Buffer buf) throws DecodeException {
        return Json.decodeValue(buf, Object.class);
    }

    public static <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        return CODEC.fromBuffer(buf, clazz);
    }
}

