/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.impl.FileResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.impl.DefaultNodeSelector;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Collection;
import java.util.Objects;

public class VertxFactory {
    private VertxOptions options;
    private Transport transport;
    private ClusterManager clusterManager;
    private NodeSelector clusterNodeSelector;
    private VertxTracer tracer;
    private VertxMetrics metrics;
    private FileResolver fileResolver;

    public VertxFactory(VertxOptions options) {
        this.options = options;
        this.clusterManager = options.getClusterManager();
    }

    public VertxFactory() {
        this(new VertxOptions());
    }

    public VertxFactory transport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public VertxFactory clusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        return this;
    }

    public VertxFactory clusterNodeSelector(NodeSelector clusterNodeSelector) {
        this.clusterNodeSelector = clusterNodeSelector;
        return this;
    }

    public VertxFactory tracer(VertxTracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public VertxFactory metrics(VertxMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public Vertx vertx() {
        VertxImpl vertx = new VertxImpl(this.options, null, null, this.createMetrics(), this.createTracer(), this.createTransport(), this.createFileResolver());
        vertx.init();
        return vertx;
    }

    public void clusteredVertx(Handler<AsyncResult<Vertx>> handler) {
        VertxImpl vertx = new VertxImpl(this.options, this.createClusterManager(), this.createNodeSelector(), this.createMetrics(), this.createTracer(), this.createTransport(), this.createFileResolver());
        vertx.initClustered(this.options, handler);
    }

    private ClusterManager createClusterManager() {
        if (this.clusterManager == null) {
            String clusterManagerClassName = System.getProperty("vertx.cluster.managerClass");
            if (clusterManagerClassName != null) {
                try {
                    Class<?> clazz = Class.forName(clusterManagerClassName);
                    this.clusterManager = (ClusterManager)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate " + clusterManagerClassName, e);
                }
            } else {
                this.clusterManager = ServiceHelper.loadFactoryOrNull(ClusterManager.class);
                if (this.clusterManager == null) {
                    throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
                }
            }
        }
        return this.clusterManager;
    }

    private NodeSelector createNodeSelector() {
        if (this.clusterNodeSelector == null) {
            Collection<NodeSelector> selectors = ServiceHelper.loadFactories(NodeSelector.class);
            this.clusterNodeSelector = !selectors.isEmpty() ? selectors.iterator().next() : new DefaultNodeSelector();
        }
        return this.clusterNodeSelector;
    }

    private Transport createTransport() {
        if (this.transport == null) {
            this.transport = Transport.transport(this.options.getPreferNativeTransport());
        }
        return this.transport;
    }

    private VertxMetrics createMetrics() {
        if (this.metrics == null && this.options.getMetricsOptions() != null && this.options.getMetricsOptions().isEnabled()) {
            VertxMetricsFactory factory = this.options.getMetricsOptions().getFactory();
            if (factory != null || (factory = ServiceHelper.loadFactoryOrNull(VertxMetricsFactory.class)) == null) {
                // empty if block
            }
            if (factory != null) {
                this.metrics = factory.metrics(this.options);
                Objects.requireNonNull(this.metrics, "The metric instance created from " + factory + " cannot be null");
            }
        }
        return this.metrics;
    }

    private VertxTracer createTracer() {
        if (this.tracer == null && this.options.getTracingOptions() != null) {
            VertxTracerFactory factory = this.options.getTracingOptions().getFactory();
            if (factory != null || (factory = ServiceHelper.loadFactoryOrNull(VertxTracerFactory.class)) == null) {
                // empty if block
            }
            if (factory != null) {
                this.tracer = factory.tracer(this.options.getTracingOptions());
                Objects.requireNonNull(this.tracer, "The tracer instance created from " + factory + " cannot be null");
            }
        }
        return this.tracer;
    }

    private FileResolver createFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = new FileResolver(this.options.getFileSystemOptions());
        }
        return this.fileResolver;
    }
}

