/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.Transformation;
import java.util.function.Function;

class MapTransformation<T, U>
extends Transformation<U>
implements Listener<T> {
    private final Function<T, U> successMapper;

    MapTransformation(ContextInternal context, Function<T, U> successMapper) {
        super(context);
        this.successMapper = successMapper;
    }

    @Override
    public void onSuccess(T value) {
        U result;
        try {
            result = this.successMapper.apply(value);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        this.tryComplete(result);
    }

    @Override
    public void onFailure(Throwable failure) {
        this.tryFail(failure);
    }
}

