/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

abstract class ContextImpl
extends AbstractContext {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    protected final VertxInternal owner;
    protected final VertxTracer<?, ?> tracer;
    protected final JsonObject config;
    private final Deployment deployment;
    private final CloseHooks closeHooks;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    private ConcurrentMap<Object, Object> data;
    private ConcurrentMap<Object, Object> localData;
    private volatile Handler<Throwable> exceptionHandler;
    final TaskQueue internalOrderedTasks;
    final WorkerPool internalBlockingPool;
    final WorkerPool workerPool;
    final TaskQueue orderedTasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeIsolated(Handler<Void> task) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)((Object)currentThread);
            ContextInternal prev = vertxThread.beginEmission(null);
            try {
                task.handle(null);
            }
            finally {
                vertxThread.endEmission(prev);
            }
        } else {
            task.handle(null);
        }
    }

    ContextImpl(VertxInternal vertx, VertxTracer<?, ?> tracer, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseHooks closeHooks, ClassLoader tccl) {
        if (VertxThread.DISABLE_TCCL && tccl != ClassLoader.getSystemClassLoader()) {
            log.warn("You have disabled TCCL checks but you have a custom TCCL to set.");
        }
        this.tracer = tracer;
        this.deployment = deployment;
        this.config = deployment != null ? deployment.config() : new JsonObject();
        this.eventLoop = eventLoop;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.closeHooks = closeHooks;
        this.internalBlockingPool = internalBlockingPool;
        this.orderedTasks = new TaskQueue();
        this.internalOrderedTasks = new TaskQueue();
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public CloseHooks closeHooks() {
        return this.closeHooks;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.add(hook);
        } else {
            this.owner.addCloseHook(hook);
        }
    }

    @Override
    public boolean isDeployment() {
        return this.deployment != null;
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        if (this.deployment != null) {
            this.closeHooks.remove(hook);
        } else {
            this.owner.removeCloseHook(hook);
        }
    }

    @Override
    public String deploymentID() {
        return this.deployment != null ? this.deployment.deploymentID() : null;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    @Override
    public VertxInternal owner() {
        return this.owner;
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextImpl.executeBlocking(this, action, this.internalBlockingPool, this.internalOrderedTasks);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking(this, action, this.internalBlockingPool, ordered ? this.internalOrderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking(this, blockingCodeHandler, this.workerPool, ordered ? this.orderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking(this, blockingCodeHandler, this.workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        PoolMetrics metrics = workerPool.metrics();
        Object queueMetric = metrics != null ? (Object)metrics.submitted() : null;
        PromiseInternal promise = context.promise();
        Future fut = promise.future();
        try {
            Runnable command = () -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                context.dispatch(promise, (E f) -> {
                    try {
                        blockingCodeHandler.handle(promise);
                    }
                    catch (Throwable e) {
                        promise.tryFail(e);
                    }
                });
                if (metrics != null) {
                    metrics.end(execMetric, fut.succeeded());
                }
            };
            ExecutorService exec = workerPool.executor();
            if (queue != null) {
                queue.execute(command, exec);
            } else {
                exec.execute(command);
            }
        }
        catch (RejectedExecutionException e) {
            if (metrics != null) {
                metrics.rejected(queueMetric);
            }
            throw e;
        }
        return fut;
    }

    @Override
    public VertxTracer tracer() {
        return this.tracer;
    }

    @Override
    public ClassLoader classLoader() {
        return this.tccl;
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<Object, Object>();
        }
        return this.data;
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> localContextData() {
        if (this.localData == null) {
            this.localData = new ConcurrentHashMap<Object, Object>();
        }
        return this.localData;
    }

    @Override
    public void reportException(Throwable t) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public int getInstanceCount() {
        if (this.deployment == null) {
            return 0;
        }
        if (this.deployment.deploymentOptions() == null) {
            return 1;
        }
        return this.deployment.deploymentOptions().getInstances();
    }

    static abstract class Duplicated<C extends ContextImpl>
    extends AbstractContext {
        protected final C delegate;
        private ConcurrentMap<Object, Object> localData;

        Duplicated(C delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isDeployment() {
            return ((ContextImpl)this.delegate).isDeployment();
        }

        @Override
        public VertxTracer tracer() {
            return ((ContextImpl)this.delegate).tracer();
        }

        @Override
        public final String deploymentID() {
            return ((ContextImpl)this.delegate).deploymentID();
        }

        @Override
        public final JsonObject config() {
            return ((ContextImpl)this.delegate).config();
        }

        @Override
        public final int getInstanceCount() {
            return ((ContextImpl)this.delegate).getInstanceCount();
        }

        @Override
        public final Context exceptionHandler(Handler<Throwable> handler) {
            ((ContextImpl)this.delegate).exceptionHandler(handler);
            return this;
        }

        @Override
        public final Handler<Throwable> exceptionHandler() {
            return ((ContextImpl)this.delegate).exceptionHandler();
        }

        @Override
        public final void addCloseHook(Closeable hook) {
            ((ContextImpl)this.delegate).addCloseHook(hook);
        }

        @Override
        public final void removeCloseHook(Closeable hook) {
            ((ContextImpl)this.delegate).removeCloseHook(hook);
        }

        @Override
        public final EventLoop nettyEventLoop() {
            return ((ContextImpl)this.delegate).nettyEventLoop();
        }

        @Override
        public final Deployment getDeployment() {
            return ((ContextImpl)this.delegate).getDeployment();
        }

        @Override
        public final VertxInternal owner() {
            return ((ContextImpl)this.delegate).owner();
        }

        @Override
        public final ClassLoader classLoader() {
            return ((ContextImpl)this.delegate).classLoader();
        }

        @Override
        public final void reportException(Throwable t) {
            ((ContextImpl)this.delegate).reportException(t);
        }

        @Override
        public final ConcurrentMap<Object, Object> contextData() {
            return ((ContextImpl)this.delegate).contextData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ConcurrentMap<Object, Object> localContextData() {
            Duplicated duplicated = this;
            synchronized (duplicated) {
                if (this.localData == null) {
                    this.localData = new ConcurrentHashMap<Object, Object>();
                }
                return this.localData;
            }
        }
    }
}

