/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.ContextInternal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class ServerWebSocketImpl
extends WebSocketImplBase<ServerWebSocketImpl>
implements ServerWebSocket {
    private final Http1xServerConnection conn;
    private final String scheme;
    private final String host;
    private final String uri;
    private final String path;
    private final String query;
    private final WebSocketServerHandshaker handshaker;
    private Http1xServerRequest request;
    private Integer status;
    private Promise<Integer> handshakePromise;

    ServerWebSocketImpl(ContextInternal context, Http1xServerConnection conn, boolean supportsContinuation, Http1xServerRequest request, WebSocketServerHandshaker handshaker, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(context, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.conn = conn;
        this.scheme = request.scheme();
        this.host = request.host();
        this.uri = request.uri();
        this.path = request.path();
        this.query = request.query();
        this.request = request;
        this.handshaker = handshaker;
        this.headers(request.headers());
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public void accept() {
        if (this.tryHandshake(101) != Boolean.TRUE) {
            throw new IllegalStateException("WebSocket already rejected");
        }
    }

    @Override
    public void reject() {
        this.reject(502);
    }

    @Override
    public void reject(int sc) {
        if (sc == 101) {
            throw new IllegalArgumentException("Invalid WebSocket rejection status code: 101");
        }
        if (this.tryHandshake(sc) != Boolean.TRUE) {
            throw new IllegalStateException("Cannot reject WebSocket, it has already been written to");
        }
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close(short statusCode, String reason) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.closed) {
                return this.context.succeededFuture();
            }
            if (this.status == null) {
                if (this.handshakePromise == null) {
                    this.tryHandshake(101);
                } else {
                    this.handshakePromise.tryComplete(101);
                }
            }
        }
        return super.close(statusCode, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerWebSocketImpl writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            Boolean check = this.checkAccept();
            if (check == null) {
                throw new IllegalStateException("Cannot write to WebSocket, it is pending accept or reject");
            }
            if (!check.booleanValue()) {
                throw new IllegalStateException("Cannot write to WebSocket, it has been rejected");
            }
            return (ServerWebSocketImpl)super.writeFrame(frame, handler);
        }
    }

    private Boolean checkAccept() {
        return this.tryHandshake(101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHandshake(int sc) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.status == null) {
                if (sc == 101) {
                    this.doHandshake();
                } else {
                    this.status = sc;
                    HttpUtils.sendError(this.conn.channel(), HttpResponseStatus.valueOf((int)sc));
                }
            }
        }
    }

    private void doHandshake() {
        Channel channel = this.conn.channel();
        try {
            this.handshaker.handshake(channel, this.request.nettyRequest());
        }
        catch (Exception e) {
            this.request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
            throw e;
        }
        finally {
            this.request = null;
        }
        this.conn.responseComplete();
        this.status = HttpResponseStatus.SWITCHING_PROTOCOLS.code();
        this.subProtocol(this.handshaker.selectedSubprotocol());
        ChannelPipeline pipeline = channel.pipeline();
        ChannelHandler handler = pipeline.get(HttpChunkContentCompressor.class);
        if (handler != null) {
            pipeline.remove(handler);
        }
        this.registerHandler(this.conn.getContext().owner().eventBus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean tryHandshake(int sc) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.status == null && this.handshakePromise == null) {
                this.setHandshake(Future.succeededFuture(sc));
            }
            return this.status == null ? null : Boolean.valueOf(this.status == sc);
        }
    }

    @Override
    public void setHandshake(Future<Integer> future, Handler<AsyncResult<Integer>> handler) {
        Future<Integer> fut = this.setHandshake(future);
        fut.onComplete(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> setHandshake(Future<Integer> future) {
        if (future == null) {
            throw new NullPointerException();
        }
        Promise p1 = Promise.promise();
        Promise p2 = Promise.promise();
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.handshakePromise != null) {
                throw new IllegalStateException();
            }
            this.handshakePromise = p1;
        }
        future.onComplete(p1);
        p1.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.handleHandshake((Integer)ar.result());
            } else {
                this.handleHandshake(500);
            }
            p2.handle(ar);
        });
        return p2.future();
    }

    @Override
    protected void doClose() {
        this.conn.channelHandlerContext().close();
    }
}

