/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.http.impl.pool.ConnectResult;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.http.impl.pool.Waiter;
import io.vertx.core.impl.ContextInternal;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

public class Pool<C> {
    private final ContextInternal context;
    private final ConnectionProvider<C> connector;
    private final Consumer<C> connectionAdded;
    private final Consumer<C> connectionRemoved;
    private final LongSupplier clock;
    private final int queueMaxSize;
    private final Deque<Waiter<C>> waitersQueue = new ArrayDeque<Waiter<C>>();
    private final Deque<Holder> available;
    private final boolean fifo;
    private long capacity;
    private long connecting;
    private final long initialWeight;
    private final long maxWeight;
    private long weight;
    private boolean checkInProgress;
    private boolean closed;
    private final Handler<Void> poolClosed;

    public Pool(Context context, ConnectionProvider<C> connector, LongSupplier clock, int queueMaxSize, long initialWeight, long maxWeight, Handler<Void> poolClosed, Consumer<C> connectionAdded, Consumer<C> connectionRemoved, boolean fifo) {
        this.clock = clock;
        this.context = (ContextInternal)context;
        this.maxWeight = maxWeight;
        this.initialWeight = initialWeight;
        this.connector = connector;
        this.queueMaxSize = queueMaxSize;
        this.poolClosed = poolClosed;
        this.available = new ArrayDeque<Holder>();
        this.connectionAdded = connectionAdded;
        this.connectionRemoved = connectionRemoved;
        this.fifo = fifo;
    }

    public synchronized int waitersInQueue() {
        return this.waitersQueue.size();
    }

    public synchronized long weight() {
        return this.weight;
    }

    public synchronized long capacity() {
        return this.capacity;
    }

    public synchronized boolean getConnection(Handler<AsyncResult<C>> handler) {
        if (this.closed) {
            return false;
        }
        Waiter<C> waiter = new Waiter<C>(handler);
        this.waitersQueue.add(waiter);
        this.checkProgress();
        return true;
    }

    public synchronized void closeIdle() {
        this.checkProgress();
    }

    private void checkProgress() {
        if (!this.checkInProgress && (this.canProgress() || this.canClose())) {
            this.checkInProgress = true;
            this.context.nettyEventLoop().execute(this::checkPendingTasks);
        }
    }

    private boolean canProgress() {
        if (this.waitersQueue.size() > 0) {
            return this.canAcquireConnection() || this.needToCreateConnection() || this.canEvictWaiter();
        }
        return this.capacity > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingTasks() {
        while (true) {
            Runnable task;
            Pool pool = this;
            synchronized (pool) {
                task = this.nextTask();
                if (task == null) {
                    this.checkInProgress = false;
                    this.checkClose();
                    break;
                }
            }
            task.run();
        }
    }

    private boolean canAcquireConnection() {
        return this.capacity > 0L;
    }

    private boolean needToCreateConnection() {
        return this.weight < this.maxWeight && (long)this.waitersQueue.size() - this.connecting > 0L;
    }

    private boolean canEvictWaiter() {
        return this.queueMaxSize >= 0 && (long)this.waitersQueue.size() - this.connecting > (long)this.queueMaxSize;
    }

    private Runnable nextTask() {
        if (this.waitersQueue.size() > 0) {
            if (this.canAcquireConnection()) {
                Holder conn = this.available.peek();
                --this.capacity;
                if (--conn.capacity == 0L) {
                    conn.expirationTimestamp = -1L;
                    this.available.poll();
                }
                Waiter<C> waiter = this.waitersQueue.poll();
                return () -> waiter.handler.handle(Future.succeededFuture(conn.connection));
            }
            if (this.needToCreateConnection()) {
                ++this.connecting;
                this.weight += this.initialWeight;
                Holder holder = new Holder();
                return holder::connect;
            }
            if (this.canEvictWaiter()) {
                Waiter<C> waiter = this.waitersQueue.removeLast();
                return () -> waiter.handler.handle(Future.failedFuture(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + this.queueMaxSize)));
            }
        } else if (this.capacity > 0L) {
            long now = this.clock.getAsLong();
            ArrayList<Holder> expired = null;
            Iterator<Holder> it = this.available.iterator();
            while (it.hasNext()) {
                Holder holder = it.next();
                if (holder.capacity != holder.concurrency || holder.expirationTimestamp != 0L && now < holder.expirationTimestamp) continue;
                it.remove();
                if (holder.capacity > 0L) {
                    this.capacity -= holder.capacity;
                }
                holder.expirationTimestamp = -1L;
                holder.capacity = 0L;
                if (expired == null) {
                    expired = new ArrayList<Holder>();
                }
                expired.add(holder);
            }
            if (expired != null) {
                ArrayList<Holder> toClose = expired;
                return () -> toClose.forEach(holder -> this.connector.close(holder.connection));
            }
        }
        return null;
    }

    private boolean canClose() {
        return this.weight == 0L && this.waitersQueue.isEmpty();
    }

    private void checkClose() {
        if (this.canClose()) {
            this.closed = true;
            this.poolClosed.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSucceeded(Holder holder, ConnectResult<C> result) {
        ArrayList<Waiter<C>> waiters;
        Pool pool = this;
        synchronized (pool) {
            --this.connecting;
            this.weight += this.initialWeight - result.weight();
            holder.init(result.concurrency(), result.connection(), result.weight());
            waiters = new ArrayList<Waiter<C>>();
            while (holder.capacity > 0L && this.waitersQueue.size() > 0) {
                waiters.add(this.waitersQueue.poll());
                --holder.capacity;
            }
            if (holder.capacity > 0L) {
                this.available.add(holder);
                this.capacity += holder.capacity;
            }
            this.checkProgress();
        }
        this.connectionAdded.accept(holder.connection);
        for (Waiter waiter : waiters) {
            waiter.handler.handle(Future.succeededFuture(holder.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectFailed(Holder holder, Throwable cause) {
        Waiter<C> waiter;
        Pool pool = this;
        synchronized (pool) {
            --this.connecting;
            waiter = this.waitersQueue.poll();
            this.weight -= this.initialWeight;
            holder.removed = true;
            this.checkProgress();
        }
        if (waiter != null) {
            waiter.handler.handle(Future.failedFuture(cause));
        }
    }

    private synchronized void setConcurrency(Holder holder, long concurrency) {
        if (concurrency < 0L) {
            throw new IllegalArgumentException("Cannot set a negative concurrency value");
        }
        if (holder.removed) {
            assert (false) : "Cannot recycle removed holder";
            return;
        }
        if (holder.concurrency < concurrency) {
            long diff = concurrency - holder.concurrency;
            if (holder.capacity == 0L) {
                this.available.add(holder);
            }
            this.capacity += diff;
            holder.capacity += diff;
            holder.concurrency = concurrency;
            this.checkProgress();
        } else if (holder.concurrency > concurrency) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(Holder holder, long timestamp) {
        Object toClose;
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Invalid timestamp");
        }
        if (holder.removed) {
            return;
        }
        Pool pool = this;
        synchronized (pool) {
            toClose = this.recycleConnection(holder, timestamp) ? holder.connection : null;
        }
        if (toClose != null) {
            this.connector.close(holder.connection);
        } else {
            pool = this;
            synchronized (pool) {
                this.checkProgress();
            }
        }
    }

    private synchronized void evicted(Holder holder) {
        if (holder.removed) {
            return;
        }
        this.evictConnection(holder);
        this.checkProgress();
    }

    private void evictConnection(Holder holder) {
        holder.removed = true;
        this.connectionRemoved.accept(holder.connection);
        if (holder.capacity > 0L) {
            this.capacity -= holder.capacity;
            this.available.remove(holder);
            holder.capacity = 0L;
        }
        this.weight -= holder.weight;
    }

    private boolean recycleConnection(Holder holder, long timestamp) {
        long newCapacity = holder.capacity + 1L;
        if (newCapacity > holder.concurrency) {
            throw new AssertionError((Object)"Attempt to recycle a connection more than permitted");
        }
        if (timestamp == 0L && newCapacity == holder.concurrency && this.capacity >= (long)this.waitersQueue.size()) {
            if (holder.capacity > 0L) {
                this.capacity -= holder.capacity;
                this.available.remove(holder);
            }
            holder.expirationTimestamp = -1L;
            holder.capacity = 0L;
            return true;
        }
        ++this.capacity;
        if (holder.capacity == 0L) {
            if (this.fifo) {
                this.available.addLast(holder);
            } else {
                this.available.addFirst(holder);
            }
        }
        holder.expirationTimestamp = timestamp;
        ++holder.capacity;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Pool pool = this;
        synchronized (pool) {
            sb.append("Available:").append(File.separator);
            this.available.forEach(holder -> sb.append(holder).append(File.separator));
            sb.append("Waiters").append(File.separator);
            this.waitersQueue.forEach(w -> sb.append(w.handler).append(File.separator));
            sb.append("InitialWeight:").append(this.initialWeight).append(File.separator);
            sb.append("MaxWeight:").append(this.maxWeight).append(File.separator);
            sb.append("Weight:").append(this.weight).append(File.separator);
            sb.append("Capacity:").append(this.capacity).append(File.separator);
            sb.append("Connecting:").append(this.connecting).append(File.separator);
            sb.append("CheckInProgress:").append(this.checkInProgress).append(File.separator);
            sb.append("Closed:").append(this.closed).append(File.separator);
        }
        return sb.toString();
    }

    public class Holder
    implements ConnectionListener<C> {
        boolean removed;
        C connection;
        long concurrency;
        long capacity;
        long weight;
        long expirationTimestamp;

        private void init(long concurrency, C conn, long weight) {
            this.concurrency = concurrency;
            this.connection = conn;
            this.weight = weight;
            this.capacity = concurrency;
            this.expirationTimestamp = -1L;
        }

        @Override
        public void onConcurrencyChange(long concurrency) {
            Pool.this.setConcurrency(this, concurrency);
        }

        @Override
        public void onRecycle(long expirationTimestamp) {
            Pool.this.recycle(this, expirationTimestamp);
        }

        @Override
        public void onEvict() {
            Pool.this.evicted(this);
        }

        void connect() {
            Pool.this.connector.connect(this, Pool.this.context, ar -> {
                if (ar.succeeded()) {
                    Pool.this.connectSucceeded(this, (ConnectResult)ar.result());
                } else {
                    Pool.this.connectFailed(this, ar.cause());
                }
            });
        }

        public String toString() {
            return "Holder[removed=" + this.removed + ",capacity=" + this.capacity + ",concurrency=" + this.concurrency + ",expirationTimestamp=" + this.expirationTimestamp + "]";
        }
    }
}

