/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.AssembledFullHttpResponse;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.spi.metrics.Metrics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

public class HttpServerResponseImpl
implements HttpServerResponse {
    private static final Buffer EMPTY_BUFFER = Buffer.buffer(Unpooled.EMPTY_BUFFER);
    private static final Logger log = LoggerFactory.getLogger(HttpServerResponseImpl.class);
    private static final String RESPONSE_WRITTEN = "Response has already been written";
    private final VertxInternal vertx;
    private final HttpRequest request;
    private final Http1xServerConnection conn;
    private HttpResponseStatus status;
    private final HttpVersion version;
    private final boolean keepAlive;
    private final boolean head;
    private final Object requestMetric;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private boolean closed;
    private final VertxHttpHeaders headers;
    private Map<String, ServerCookie> cookies;
    private MultiMap trailers;
    private io.netty.handler.codec.http.HttpHeaders trailingHeaders = EmptyHttpHeaders.INSTANCE;
    private String statusMessage;
    private long bytesWritten;
    private NetSocket netSocket;

    HttpServerResponseImpl(VertxInternal vertx, Http1xServerConnection conn, HttpRequest request, Object requestMetric) {
        this.vertx = vertx;
        this.conn = conn;
        this.version = request.protocolVersion();
        this.headers = new VertxHttpHeaders();
        this.request = request;
        this.status = HttpResponseStatus.OK;
        this.requestMetric = requestMetric;
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 && !request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.CLOSE, true) || this.version == HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
        this.head = request.method() == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            VertxHttpHeaders v = new VertxHttpHeaders();
            this.trailers = v;
            this.trailingHeaders = v;
        }
        return this.trailers;
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        this.status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf((int)statusCode);
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.status.reasonPhrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.statusMessage = statusMessage;
            this.status = new HttpResponseStatus(this.status.code(), statusMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl setChunked(boolean chunked) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            if (this.version != HttpVersion.HTTP_1_0) {
                this.headers.set(HttpHeaders.TRANSFER_ENCODING, (CharSequence)(chunked ? "chunked" : null));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headers.contains(HttpHeaders.TRANSFER_ENCODING, HttpHeaders.CHUNKED, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putHeader(String key, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.headers.set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putHeader(String key, Iterable<String> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.headers.set(key, (Iterable)values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putTrailer(String key, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putTrailer(String key, Iterable<String> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.headers.set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.headers.set(name, (Iterable)values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.conn.doSetWriteQueueMaxSize(size);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            return this.conn.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            this.conn.getContext().runOnContext(v -> this.conn.handleInterestedOpsChanged());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public HttpServerResponseImpl write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf, (ChannelPromise)this.conn.voidPromise);
    }

    @Override
    public HttpServerResponse write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        return this.write(chunk.getByteBuf(), this.conn.toPromise(handler));
    }

    @Override
    public HttpServerResponseImpl write(String chunk, String enc) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf(), (ChannelPromise)this.conn.voidPromise);
    }

    @Override
    public HttpServerResponse write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf(), this.conn.toPromise(handler));
    }

    @Override
    public HttpServerResponseImpl write(String chunk) {
        return this.write(Buffer.buffer(chunk).getByteBuf(), (ChannelPromise)this.conn.voidPromise);
    }

    @Override
    public HttpServerResponse write(String chunk, Handler<AsyncResult<Void>> handler) {
        return this.write(Buffer.buffer(chunk).getByteBuf(), this.conn.toPromise(handler));
    }

    @Override
    public HttpServerResponse writeContinue() {
        this.conn.write100Continue();
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk, enc), handler);
    }

    @Override
    public void end(Buffer chunk) {
        this.end(chunk, (ChannelPromise)this.conn.voidPromise);
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.end(chunk, this.conn.toPromise(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(Buffer chunk, ChannelPromise promise) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            Object msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            ByteBuf data = chunk.getByteBuf();
            this.bytesWritten += (long)data.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(this.bytesWritten);
                msg = new AssembledFullHttpResponse(this.head, this.version, this.status, this.headers, data, this.trailingHeaders);
            } else {
                msg = new AssembledLastHttpContent(data, this.trailingHeaders);
            }
            this.conn.writeToChannel(msg, promise);
            this.written = true;
            this.conn.responseComplete();
            if (this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
            if (!this.closed && this.endHandler != null) {
                this.endHandler.handle(null);
            }
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.closed) {
                if (this.headWritten) {
                    this.closeConnAfterWrite();
                } else {
                    this.conn.close();
                }
                this.closed = true;
            }
        }
    }

    @Override
    public void end() {
        this.end(EMPTY_BUFFER);
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.end(EMPTY_BUFFER, handler);
    }

    @Override
    public HttpServerResponseImpl sendFile(String filename, long offset, long length) {
        this.doSendFile(filename, offset, length, null);
        return this;
    }

    @Override
    public HttpServerResponse sendFile(String filename, long start, long end, Handler<AsyncResult<Void>> resultHandler) {
        this.doSendFile(filename, start, end, resultHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            ChannelFuture channelFuture;
            String contentType;
            long contentLength;
            this.checkValid();
            if (this.headWritten) {
                throw new IllegalStateException("Head already written");
            }
            File file = this.vertx.resolveFile(filename);
            if (!file.exists()) {
                if (resultHandler != null) {
                    ContextInternal ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                } else {
                    log.error("File not found: " + filename);
                }
                return;
            }
            this.bytesWritten = contentLength = Math.min(length, file.length() - offset);
            if (!this.headers.contains(HttpHeaders.CONTENT_TYPE) && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                this.headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.prepareHeaders(this.bytesWritten);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(file, "r");
                this.conn.writeToChannel(new AssembledHttpResponse(this.head, this.version, this.status, this.headers));
                channelFuture = this.conn.sendFile(raf, Math.min(offset, file.length()), contentLength);
            }
            catch (IOException e) {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (resultHandler != null) {
                    ContextInternal ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                } else {
                    log.error((Object)"Failed to send file", e);
                }
                return;
            }
            this.written = true;
            ContextInternal ctx = this.vertx.getOrCreateContext();
            channelFuture.addListener(future -> {
                Handler<Void> handler;
                if (future.isSuccess()) {
                    ChannelPromise pr = this.conn.channelHandlerContext().newPromise();
                    this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT, pr);
                    if (!this.keepAlive) {
                        pr.addListener(a -> this.closeConnAfterWrite());
                    }
                }
                if (resultHandler != null) {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    ctx.executeFromIO(v -> resultHandler.handle(res));
                }
                Http1xServerConnection http1xServerConnection = this.conn;
                synchronized (http1xServerConnection) {
                    handler = this.bodyEndHandler;
                }
                if (handler != null) {
                    ctx.executeFromIO(v -> handler.handle(null));
                }
                this.conn.responseComplete();
            });
        }
    }

    private void closeConnAfterWrite() {
        ChannelPromise channelFuture = this.conn.channelFuture();
        this.conn.writeToChannel(Unpooled.EMPTY_BUFFER, channelFuture);
        channelFuture.addListener(fut -> this.conn.close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.drainHandler != null) {
                this.drainHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        if (t == Http1xServerConnection.CLOSED_EXCEPTION) {
            this.handleClosed();
        } else {
            Handler<Throwable> handler;
            Http1xServerConnection http1xServerConnection = this.conn;
            synchronized (http1xServerConnection) {
                handler = this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosed() {
        Handler<Void> closedHandler;
        Handler<Void> endHandler;
        Handler<Throwable> exceptionHandler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            exceptionHandler = this.written ? null : this.exceptionHandler;
            endHandler = this.written ? null : this.endHandler;
            closedHandler = this.closeHandler;
        }
        if (exceptionHandler != null) {
            exceptionHandler.handle(ConnectionBase.CLOSED_EXCEPTION);
        }
        if (endHandler != null) {
            endHandler.handle(null);
        }
        if (closedHandler != null) {
            closedHandler.handle(null);
        }
    }

    private void checkValid() {
        if (this.written) {
            throw new IllegalStateException(RESPONSE_WRITTEN);
        }
    }

    private void prepareHeaders(long contentLength) {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        } else if (this.version == HttpVersion.HTTP_1_1 && !this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.CLOSE);
        }
        if (this.head || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (!this.headers.contains(HttpHeaders.TRANSFER_ENCODING) && !this.headers.contains(HttpHeaders.CONTENT_LENGTH) && contentLength >= 0L) {
            String value = contentLength == 0L ? "0" : String.valueOf(contentLength);
            this.headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)value);
        }
        if (this.headersEndHandler != null) {
            this.headersEndHandler.handle(null);
        }
        if (this.cookies != null) {
            this.setCookies();
        }
        if (Metrics.METRICS_ENABLED) {
            this.reportResponseBegin();
        }
        this.headWritten = true;
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies.values()) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, (CharSequence)cookie.encode());
        }
    }

    private void reportResponseBegin() {
        if (this.conn.metrics != null) {
            this.conn.metrics.responseBegin(this.requestMetric, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServerResponseImpl write(ByteBuf chunk, ChannelPromise promise) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            Object msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            if (!(this.headWritten || this.headers.contains(HttpHeaders.TRANSFER_ENCODING) || this.headers.contains(HttpHeaders.CONTENT_LENGTH) || this.version == HttpVersion.HTTP_1_0)) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.bytesWritten += (long)chunk.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(-1L);
                msg = new AssembledHttpResponse(this.head, this.version, this.status, this.headers, chunk);
            } else {
                msg = new DefaultHttpContent(chunk);
            }
            this.conn.writeToChannel(msg, promise);
            return this;
        }
    }

    NetSocket netSocket(boolean isConnect) {
        this.checkValid();
        if (this.netSocket == null) {
            if (isConnect) {
                if (this.headWritten) {
                    throw new IllegalStateException("Response for CONNECT already sent");
                }
                this.status = HttpResponseStatus.OK;
                this.prepareHeaders(-1L);
                this.conn.writeToChannel(new AssembledHttpResponse(this.head, this.version, this.status, this.headers));
            }
            this.written = true;
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    @Override
    public int streamId() {
        return -1;
    }

    @Override
    public void reset(long code) {
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path, headers, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, path, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, path, null, null, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        handler.handle(Future.failedFuture("Push promise is only supported with HTTP2"));
        return this;
    }

    @Override
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        return this;
    }

    Map<String, ServerCookie> cookies() {
        if (this.cookies == null) {
            this.cookies = CookieImpl.extractCookies(this.request.headers().get(HttpHeaders.COOKIE));
        }
        return this.cookies;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        this.cookies().put(cookie.getName(), (ServerCookie)cookie);
        return this;
    }

    @Override
    public @Nullable Cookie removeCookie(String name, boolean invalidate) {
        return CookieImpl.removeCookie(this.cookies, name, invalidate);
    }
}

