/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

class Http1xClientConnection
extends Http1xConnectionBase<WebSocketImpl>
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    private final Object endpointMetric;
    private final HttpClientMetrics metrics;
    private final HttpVersion version;
    private StreamImpl requestInProgress;
    private StreamImpl responseInProgress;
    private boolean close;
    private boolean upgraded;
    private int keepAliveTimeout;
    private int seq = 1;

    Http1xClientConnection(ConnectionListener<HttpClientConnection> listener, HttpVersion version, HttpClientImpl client, Object endpointMetric, ChannelHandlerContext channel, boolean ssl, SocketAddress server, ContextInternal context, HttpClientMetrics metrics) {
        super(client.getVertx(), channel, context);
        this.listener = listener;
        this.client = client;
        this.options = client.getOptions();
        this.ssl = ssl;
        this.server = server;
        this.metrics = metrics;
        this.version = version;
        this.endpointMetric = endpointMetric;
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
    }

    Object endpointMetric() {
        return this.endpointMetric;
    }

    ConnectionListener<HttpClientConnection> listener() {
        return this.listener;
    }

    private synchronized NetSocket upgrade(final StreamImpl stream) {
        if (this.options.isPipelining()) {
            throw new IllegalStateException("Cannot upgrade a pipe-lined request");
        }
        if (this.upgraded) {
            throw new IllegalStateException("Request already upgraded to NetSocket");
        }
        this.upgraded = true;
        final AtomicBoolean paused = new AtomicBoolean(false);
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.client.getSslHelper(), this.metrics){
            {
                super(vertx, channel, context, helper, metrics);
                super.pause();
            }

            @Override
            public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
                return super.handler((Handler)dataHandler);
            }

            @Override
            public synchronized NetSocket pause() {
                paused.set(true);
                return super.pause();
            }

            @Override
            public synchronized NetSocket resume() {
                paused.set(false);
                return super.resume();
            }

            @Override
            public synchronized void handleMessage(Object msg) {
                if (msg instanceof HttpContent) {
                    if (msg instanceof LastHttpContent) {
                        stream.endResponse((LastHttpContent)msg);
                    }
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.handleMessage(msg);
            }

            @Override
            protected void handleClosed() {
                Http1xClientConnection.this.listener.onEvict();
                super.handleClosed();
            }
        };
        socket.metric(this.metric());
        this.flush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        pipeline.replace("handler", "handler", VertxHandler.create(socket));
        pipeline.remove("codec");
        this.context.runOnContext(v -> {
            if (!paused.get()) {
                socket.resume();
            }
        });
        return socket;
    }

    private void checkLifecycle() {
        if (!this.upgraded) {
            if (this.close) {
                this.close();
            } else {
                this.recycle();
            }
        }
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + version);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            HttpObject obj = (HttpObject)msg;
            this.handleHttpMessage(obj);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        } else {
            throw new IllegalStateException("Invalid object " + msg);
        }
    }

    private void handleHttpMessage(HttpObject obj) {
        if (obj instanceof HttpResponse) {
            this.handleResponseBegin((HttpResponse)obj);
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk.content(), this.chctx.alloc()));
                this.handleResponseChunk(buff);
            }
            if (chunk instanceof LastHttpContent) {
                this.handleResponseEnd((LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(HttpResponse resp) {
        if (resp.status().code() == 100) {
            Handler handler;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                StreamImpl stream = this.responseInProgress;
                handler = stream.continueHandler;
            }
            if (handler != null) {
                handler.handle(null);
            }
        } else {
            HttpClientResponseImpl response;
            HttpClientRequestImpl request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                StreamImpl stream = this.responseInProgress;
                request = stream.request;
                response = stream.beginResponse(resp);
            }
            request.handleResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseChunk(Buffer buff) {
        StreamImpl resp;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            resp = this.responseInProgress;
        }
        if (resp != null && !resp.handleChunk(buff)) {
            this.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(LastHttpContent trailer) {
        StreamImpl stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responseInProgress;
            if (stream.response == null) {
                return;
            }
            this.responseInProgress = stream.next;
        }
        if (stream.endResponse(trailer)) {
            this.checkLifecycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestEnd(boolean recycle) {
        StreamImpl next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.requestInProgress = next = this.requestInProgress.next;
        }
        if (recycle) {
            this.recycle();
        }
        if (next != null) {
            next.fut.complete(next);
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, List<String> subProtocols, int maxWebSocketFrameSize, Handler<AsyncResult<WebSocket>> wsHandler) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((String)((Enum)(vers == null ? WebSocketVersion.V13 : vers)).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebsocketExtensionHandshakers(this.client.getOptions());
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "websocketsExtensionsHandler", (ChannelHandler)new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[0])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)wsuri, (WebSocketVersion)version, (String)subp, (!extensionHandshakers.isEmpty() ? 1 : 0) != 0, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders, (int)maxWebSocketFrameSize, (!this.options.isSendUnmaskedFrames() ? 1 : 0) != 0, (boolean)false, (long)-1L);
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, ar -> {
                AsyncResult<Function<Void, WebSocket>> wsRes = ar.map(v -> {
                    WebSocketImpl w = new WebSocketImpl(this, version != WebSocketVersion.V00, this.options.getMaxWebsocketFrameSize(), this.options.getMaxWebsocketMessageSize());
                    w.subProtocol(handshaker.actualSubprotocol());
                    return w;
                });
                if (ar.failed()) {
                    this.close();
                } else {
                    this.ws = (WebSocketImpl)((Object)wsRes.result());
                    ((WebSocketImpl)this.ws).registerHandler(this.vertx.eventBus());
                }
                this.getContext().executeFromIO(wsRes, res -> {
                    if (res.succeeded()) {
                        log.debug("WebSocket handshake complete");
                        if (this.metrics != null) {
                            ((WebSocketImpl)this.ws).setMetric(this.metrics.connected(this.endpointMetric, this.metric(), (WebSocket)((Object)this.ws)));
                        }
                    }
                    wsHandler.handle((AsyncResult<WebSocket>)res);
                });
            });
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)handshakeInboundHandler);
            handshaker.handshake(this.chctx.channel()).addListener(f -> {
                if (!f.isSuccess()) {
                    wsHandler.handle(Future.failedFuture(f.cause()));
                }
            });
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebsocketExtensionHandshakers(HttpClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryWebsocketDeflateFrameCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new DeflateFrameClientExtensionHandshaker(options.getWebsocketCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageWebsocketCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new PerMessageDeflateClientExtensionHandshaker(options.getWebsocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getWebsocketCompressionAllowClientNoContext(), options.getWebsocketCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            StreamImpl current = this.requestInProgress;
            if (current != null) {
                current.request.handleDrained();
            } else if (this.ws != null) {
                ((WebSocketImpl)this.ws).handleDrained();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        WebSocketImpl ws;
        super.handleClosed();
        if (this.metrics != null) {
            this.metrics.endpointDisconnected(this.endpointMetric, this.metric());
        }
        List<StreamImpl> list = Collections.emptyList();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.ws;
            StreamImpl r = this.responseInProgress;
            while (r != null) {
                if (this.metrics != null) {
                    this.metrics.requestReset(r.metric);
                }
                if (list.isEmpty()) {
                    list = new ArrayList<StreamImpl>();
                }
                list.add(r);
                r = r.next;
            }
        }
        if (ws != null) {
            ws.handleClosed();
        }
        for (StreamImpl stream : list) {
            stream.handleException(CLOSED_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle() {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.ws == null && this.responseInProgress == null) {
                return;
            }
        }
        super.handleIdle();
    }

    @Override
    protected synchronized void handleException(Throwable e) {
        super.handleException(e);
        if (this.ws != null) {
            ((WebSocketImpl)this.ws).handleException(e);
        } else {
            StreamImpl r = this.responseInProgress;
            while (r != null) {
                r.handleException(e);
                r = r.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(Handler<AsyncResult<HttpClientStream>> handler) {
        StreamImpl stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = new StreamImpl(this, this.seq++, handler);
            if (this.requestInProgress != null) {
                this.requestInProgress.append(stream);
                return;
            }
            this.requestInProgress = stream;
        }
        stream.fut.complete(stream);
    }

    private void recycle() {
        long expiration = this.keepAliveTimeout == 0 ? 0L : System.currentTimeMillis() + (long)(this.keepAliveTimeout * 1000);
        this.listener.onRecycle(expiration);
    }

    private static class StreamImpl
    implements HttpClientStream {
        private final int id;
        private final Http1xClientConnection conn;
        private final Promise<HttpClientStream> fut;
        private final InboundBuffer<Object> queue;
        private HttpClientRequestImpl request;
        private Handler<Void> continueHandler;
        private HttpClientResponseImpl response;
        private boolean requestEnded;
        private boolean responseEnded;
        private boolean reset;
        private StreamImpl next;
        private long bytesWritten;
        private long bytesRead;
        private Object metric;

        StreamImpl(Http1xClientConnection conn, int id, Handler<AsyncResult<HttpClientStream>> handler) {
            Promise promise = Promise.promise();
            promise.future().setHandler(handler);
            this.conn = conn;
            this.fut = promise;
            this.id = id;
            this.queue = new InboundBuffer(conn.context, 5L);
        }

        private void append(StreamImpl s) {
            StreamImpl c = this;
            while (c.next != null) {
                c = c.next;
            }
            c.next = s;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return this.metric;
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public Context getContext() {
            return this.conn.context;
        }

        @Override
        public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, Handler<Void> contHandler, Handler<AsyncResult<Void>> handler) {
            HttpRequest request = this.createRequest(method, rawMethod, uri, headers);
            this.prepareRequestHeaders(request, hostHeader, chunked);
            if (buf != null) {
                this.bytesWritten += (long)buf.readableBytes();
            }
            this.continueHandler = contHandler;
            this.sendRequest(request, buf, end, handler);
            if (this.conn.responseInProgress == null) {
                this.conn.responseInProgress = this;
            } else {
                this.conn.responseInProgress.append(this);
            }
            this.next = null;
        }

        private HttpRequest createRequest(HttpMethod method, String rawMethod, String uri, MultiMap headers) {
            DefaultHttpRequest request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.conn.version), HttpUtils.toNettyHttpMethod(method, rawMethod), uri, false);
            if (headers != null) {
                for (Map.Entry header : headers) {
                    request.headers().add((String)header.getKey(), header.getValue());
                }
            }
            return request;
        }

        private void prepareRequestHeaders(HttpRequest request, String hostHeader, boolean chunked) {
            io.netty.handler.codec.http.HttpHeaders headers = request.headers();
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
            if (!headers.contains(HttpHeaders.HOST)) {
                request.headers().set(HttpHeaders.HOST, (Object)hostHeader);
            }
            if (chunked) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
            }
            if (this.conn.options.isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
                request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
            }
            if (!this.conn.options.isKeepAlive() && this.conn.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
                request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
            } else if (this.conn.options.isKeepAlive() && this.conn.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
                request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
            }
        }

        private void sendRequest(HttpRequest request, ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
            if (end) {
                request = buf != null ? new AssembledFullHttpRequest(request, buf) : new AssembledFullHttpRequest(request);
            } else if (buf != null) {
                request = new AssembledHttpRequest(request, buf);
            }
            this.conn.writeToChannel(request, this.conn.toPromise(handler));
        }

        private boolean handleChunk(Buffer buff) {
            this.bytesRead += (long)buff.length();
            return this.queue.write(buff);
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buff == null && !end) {
                return;
            }
            Object msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
            this.bytesWritten += (long)msg.content().readableBytes();
            this.conn.writeToChannel(msg, this.conn.toPromise(handler));
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.conn.isNotWritable();
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(Throwable cause) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.reset) {
                    return;
                }
                this.reset = true;
            }
            this.handleException(cause);
            http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.conn.requestInProgress == this) {
                    if (this.request == null) {
                        this.conn.handleRequestEnd(true);
                    } else {
                        this.conn.close();
                    }
                } else if (!this.responseEnded) {
                    this.conn.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginRequest(HttpClientRequestImpl req) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.request != null) {
                    throw new IllegalStateException("Already writing a request");
                }
                if (this.conn.requestInProgress != this) {
                    throw new IllegalStateException("Connection is already writing another request");
                }
                this.request = req;
                if (this.conn.metrics != null) {
                    this.metric = this.conn.metrics.requestBegin(this.conn.endpointMetric, this.conn.metric(), this.conn.localAddress(), this.conn.remoteAddress(), this.request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endRequest() {
            boolean doRecycle;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                StreamImpl s = this.conn.requestInProgress;
                if (s != this) {
                    throw new IllegalStateException("No write in progress");
                }
                if (this.requestEnded) {
                    throw new IllegalStateException("Request already sent");
                }
                this.requestEnded = true;
                if (this.conn.metrics != null) {
                    this.conn.metrics.requestEnd(this.metric);
                }
                doRecycle = this.responseEnded;
            }
            this.conn.reportBytesWritten(this.bytesWritten);
            this.conn.handleRequestEnd(doRecycle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocket createNetSocket() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.responseEnded) {
                    throw new IllegalStateException("Response already ended");
                }
                return this.conn.upgrade(this);
            }
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        private HttpClientResponseImpl beginResponse(HttpResponse resp) {
            HttpVersion version = resp.protocolVersion() == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            this.response = new HttpClientResponseImpl(this.request, version, this, resp.status().code(), resp.status().reasonPhrase(), new HeadersAdaptor(resp.headers()));
            if (this.conn.metrics != null) {
                this.conn.metrics.responseBegin(this.metric, this.response);
            }
            if (resp.status().code() != 100 && this.request.method() != HttpMethod.CONNECT) {
                int timeout;
                String responseConnectionHeader = resp.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
                io.netty.handler.codec.http.HttpVersion protocolVersion = resp.protocolVersion();
                String requestConnectionHeader = this.request.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
                if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)requestConnectionHeader)) {
                    this.conn.close = true;
                } else if (protocolVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader)) {
                    this.conn.close = true;
                }
                String keepAliveHeader = resp.headers().get((CharSequence)HttpHeaderNames.KEEP_ALIVE);
                if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                    this.conn.keepAliveTimeout = timeout;
                }
            }
            this.queue.handler(item -> {
                if (item instanceof MultiMap) {
                    this.conn.reportBytesRead(this.bytesRead);
                    this.response.handleEnd((MultiMap)item);
                } else {
                    this.response.handleChunk((Buffer)item);
                }
            });
            this.queue.drainHandler(v -> {
                if (!this.responseEnded) {
                    this.conn.doResume();
                }
            });
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean endResponse(LastHttpContent trailer) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.conn.metrics != null) {
                    this.conn.metrics.responseEnd(this.metric, this.response);
                }
            }
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
            http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                this.responseEnded = true;
                Http1xClientConnection http1xClientConnection2 = this.conn;
                http1xClientConnection2.close = http1xClientConnection2.close | !this.conn.options.isKeepAlive();
                this.conn.doResume();
                return this.requestEnded;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleException(Throwable cause) {
            boolean requestEnded;
            Promise<HttpClientStream> fut;
            HttpClientResponseImpl response;
            HttpClientRequestImpl request;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                request = this.request;
                response = this.response;
                fut = this.fut;
                requestEnded = this.requestEnded;
            }
            if (request != null) {
                if (response == null) {
                    request.handleException(cause);
                } else {
                    if (!requestEnded) {
                        request.handleException(cause);
                    }
                    response.handleException(cause);
                }
            } else {
                fut.tryFail(cause);
            }
        }
    }
}

