/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.ProxyOptionsConverter;
import io.vertx.core.net.ProxyType;
import java.util.Objects;

@DataObject(generateConverter=true, publicConverter=false)
public class ProxyOptions {
    public static final ProxyType DEFAULT_TYPE = ProxyType.HTTP;
    public static final int DEFAULT_PORT = 3128;
    public static final String DEFAULT_HOST = "localhost";
    private String host;
    private int port;
    private String username;
    private String password;
    private ProxyType type;

    public ProxyOptions() {
        this.host = DEFAULT_HOST;
        this.port = 3128;
        this.type = DEFAULT_TYPE;
    }

    public ProxyOptions(ProxyOptions other) {
        this.host = other.getHost();
        this.port = other.getPort();
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.type = other.getType();
    }

    public ProxyOptions(JsonObject json) {
        this();
        ProxyOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ProxyOptionsConverter.toJson(this, json);
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public ProxyOptions setHost(String host) {
        Objects.requireNonNull(host, "Proxy host may not be null");
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid proxy port " + port);
        }
        this.port = port;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ProxyOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public ProxyType getType() {
        return this.type;
    }

    public ProxyOptions setType(ProxyType type) {
        Objects.requireNonNull(type, "Proxy type may not be null");
        this.type = type;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientOptionsBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxyOptions that = (ProxyOptions)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.host.equals(that.host)) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        return Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        return result;
    }
}

